/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.io;

import io.datafx.io.MultiValuedMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class OAuth {
    public static final String SIGNATURE = "oauth_signature";
    public static final String NONCE = "oauth_nonce";
    public static final String VERSION = "oauth_version";
    public static final String CONSUMER_KEY = "oauth_consumer_key";
    public static final String SIGNATURE_METHOD = "oauth_signature_method";
    public static final String TIMESTAMP = "oauth_timestamp";

    OAuth() {
    }

    public static String getHeader(String method, String url, MultiValuedMap requestParams, String consumerKey, String consumerSecret) throws UnsupportedEncodingException, GeneralSecurityException {
        TreeSet<String> params = new TreeSet<String>();
        for (Map.Entry entry : requestParams.entrySet()) {
            String key = (String)entry.getKey();
            for (String val : (List)entry.getValue()) {
                params.add(OAuth.percentEncode(key) + "=" + OAuth.percentEncode(val));
            }
        }
        String nonce = OAuth.getNonce();
        params.add(OAuth.percentEncode(NONCE) + "=" + OAuth.percentEncode(nonce));
        String version = "1.0";
        params.add(OAuth.percentEncode(VERSION) + "=" + OAuth.percentEncode(version));
        String timeStamp = Long.toString(System.currentTimeMillis() / 1000L);
        params.add(OAuth.percentEncode(TIMESTAMP) + "=" + OAuth.percentEncode(timeStamp));
        String signatureMethod = "HMAC-SHA1";
        params.add(OAuth.percentEncode(SIGNATURE_METHOD) + "=" + OAuth.percentEncode(signatureMethod));
        params.add(OAuth.percentEncode(CONSUMER_KEY) + "=" + OAuth.percentEncode(consumerKey));
        int idx = 0;
        int psize = params.size();
        StringBuilder sb = new StringBuilder();
        for (String part : params) {
            sb.append(part);
            if (++idx >= psize) continue;
            sb.append("&");
        }
        String baseString = method + "&" + OAuth.percentEncode(url) + "&" + OAuth.percentEncode(sb.toString());
        String signKey = OAuth.percentEncode(consumerSecret) + "&";
        String signature = OAuth.computeSignature(baseString, signKey);
        StringBuilder sh = new StringBuilder("OAuth ");
        sh.append(OAuth.percentEncode(SIGNATURE)).append("=\"").append(OAuth.percentEncode(signature)).append("\"");
        sh.append(", ");
        sh.append(OAuth.percentEncode(NONCE)).append("=\"").append(OAuth.percentEncode(nonce)).append("\"");
        sh.append(", ");
        sh.append(OAuth.percentEncode(VERSION)).append("=\"").append(OAuth.percentEncode(version)).append("\"");
        sh.append(", ");
        sh.append(OAuth.percentEncode(CONSUMER_KEY)).append("=\"").append(OAuth.percentEncode(consumerKey)).append("\"");
        sh.append(", ");
        sh.append(OAuth.percentEncode(SIGNATURE_METHOD)).append("=\"").append(OAuth.percentEncode(signatureMethod)).append("\"");
        sh.append(", ");
        sh.append(OAuth.percentEncode(TIMESTAMP)).append("=\"").append(OAuth.percentEncode(timeStamp)).append("\"");
        return sh.toString();
    }

    private static String getNonce() {
        String answer = UUID.randomUUID().toString();
        return answer;
    }

    private static String percentEncode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException wow) {
            throw new RuntimeException(wow.getMessage(), wow);
        }
    }

    private static String computeSignature(String baseString, String secret) throws GeneralSecurityException, UnsupportedEncodingException {
        byte[] sb = secret.getBytes();
        SecretKeySpec secretKey = new SecretKeySpec(sb, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(secretKey);
        byte[] text = baseString.getBytes();
        byte[] digest = mac.doFinal(text);
        String answer = Base64.getEncoder().encodeToString(digest);
        return answer;
    }
}

