/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.provider;

import io.datafx.io.DataReader;
import io.datafx.io.WriteBackHandler;
import io.datafx.provider.ObjectDataProvider;
import javafx.beans.property.ObjectProperty;

public final class ObjectDataProviderBuilder<T> {
    private final ObjectDataProvider objectDataProvider = new ObjectDataProvider();

    public static <T> ObjectDataProviderBuilder create() {
        return new ObjectDataProviderBuilder<T>();
    }

    private ObjectDataProviderBuilder() {
    }

    public ObjectDataProviderBuilder dataReader(DataReader<T> dataReader) {
        this.objectDataProvider.setDataReader(dataReader);
        return this;
    }

    public ObjectDataProviderBuilder resultProperty(ObjectProperty<T> result) {
        this.objectDataProvider.setResultObjectProperty(result);
        return this;
    }

    public ObjectDataProviderBuilder writeBackHandler(WriteBackHandler<T> handler) {
        this.objectDataProvider.setWriteBackHandler(handler);
        return this;
    }

    public ObjectDataProvider build() {
        return this.objectDataProvider;
    }
}

