/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.io;

import io.datafx.io.MultiValuedMap;
import io.datafx.io.RestSource;
import io.datafx.io.converter.InputStreamConverter;
import java.util.HashMap;
import java.util.Map;

public class RestSourceBuilder<T> {
    protected RestSource<T> restSource;
    private String path = "";
    private Map<String, String> queryParams = new HashMap<String, String>();
    private MultiValuedMap formParams = new MultiValuedMap();

    public static <T> RestSourceBuilder create() {
        return new RestSourceBuilder<T>();
    }

    protected RestSourceBuilder() {
        this.restSource = new RestSource();
    }

    public RestSourceBuilder converter(InputStreamConverter<T> converter) {
        this.restSource.setConverter(converter);
        return this;
    }

    public RestSourceBuilder path(String p) {
        this.path = this.path + "/" + p;
        return this;
    }

    public RestSourceBuilder requestMethod(String requestMethod) {
        this.restSource.setRequestMethod(requestMethod);
        return this;
    }

    public RestSourceBuilder queryParam(String key, String value) {
        this.queryParams.put(key, value);
        return this;
    }

    public RestSourceBuilder formParam(String key, String value) {
        this.formParams.put(key, value);
        return this;
    }

    public RestSourceBuilder dataString(String dataString) {
        this.restSource.setDataString(dataString);
        return this;
    }

    public RestSourceBuilder consumerKey(String consumerKey) {
        this.restSource.setConsumerKey(consumerKey);
        return this;
    }

    public RestSourceBuilder consumerSecret(String consumerSecret) {
        this.restSource.setConsumerSecret(consumerSecret);
        return this;
    }

    public RestSourceBuilder contentType(String contentType) {
        this.restSource.setContentType(contentType);
        return this;
    }

    public RestSourceBuilder host(String host) {
        this.restSource.setHost(host);
        return this;
    }

    public RestSourceBuilder timeout(int timeout) {
        this.restSource.setTimeout(timeout);
        return this;
    }

    public RestSource build() {
        this.restSource.setQueryParams(this.queryParams);
        this.restSource.setFormParams(this.formParams);
        this.restSource.setPath(this.path);
        return this.restSource;
    }
}

