/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.provider;

import io.datafx.core.concurrent.ConcurrentUtils;
import io.datafx.core.concurrent.ObservableExecutor;
import io.datafx.io.DataReader;
import io.datafx.io.ServerSentEventReader;
import io.datafx.io.WritableDataReader;
import io.datafx.io.WriteBackHandler;
import io.datafx.io.WriteBackProvider;
import io.datafx.provider.DataProvider;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;

public class ObjectDataProvider<T>
implements DataProvider<T>,
WriteBackProvider<T> {
    private ObjectProperty<T> objectProperty;
    private Executor executor;
    private DataReader<T> reader;
    private WriteBackHandler<T> writeBackHandler;
    private static final Logger LOGGER = Logger.getLogger(ObjectDataProvider.class.getName());

    public ObjectDataProvider() {
        this(null, null);
    }

    public ObjectDataProvider(DataReader<T> reader) {
        this(reader, null);
    }

    public ObjectDataProvider(DataReader<T> reader, Executor executor) {
        this.reader = reader;
        this.executor = executor;
        this.objectProperty = new SimpleObjectProperty();
    }

    public void setDataReader(DataReader<T> reader) {
        this.reader = reader;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void setResultProperty(Property<T> result) {
        this.setResultObjectProperty((ObjectProperty)result);
    }

    public void setResultObjectProperty(ObjectProperty<T> result) {
        this.objectProperty = result;
    }

    @Override
    public Worker<T> retrieve() {
        Service<T> retriever = this.createService(this.objectProperty);
        return ConcurrentUtils.executeService((Executor)this.executor, retriever);
    }

    private void handleKeepReading(ServerSentEventReader reader) {
        Service retriever = this.createKeepReadingService(reader);
        if (this.executor != null && this.executor instanceof ObservableExecutor) {
            ((ObservableExecutor)this.executor).submit(retriever);
        } else {
            if (this.executor != null) {
                retriever.setExecutor(this.executor);
            }
            retriever.start();
        }
    }

    private Service createKeepReadingService(final ServerSentEventReader reader) {
        return new Service(){

            protected Task createTask() {
                return ObjectDataProvider.this.createKeepReadingTask(reader);
            }
        };
    }

    private Task createKeepReadingTask(final ServerSentEventReader reader) {
        Task answer = new Task(){

            protected Object call() throws Exception {
                reader.keepReading();
                return null;
            }
        };
        return answer;
    }

    protected Task<T> createReceiverTask(final DataReader<T> reader) {
        Task answer = new Task<T>(){

            protected T call() throws Exception {
                final Object entry = reader.get();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ObjectDataProvider.this.objectProperty.set(entry);
                    }
                });
                LOGGER.log(Level.FINE, "[datafx] Reader did read entry {0}", entry);
                return entry;
            }
        };
        return answer;
    }

    protected Service<T> createService(ObjectProperty<T> value) {
        return new Service<T>(){

            protected Task<T> createTask() {
                LOGGER.fine("[datafx] create Receiver task");
                final Task task = ObjectDataProvider.this.createReceiverTask(ObjectDataProvider.this.reader);
                task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                    public void handle(WorkerStateEvent arg0) {
                        Object value = null;
                        try {
                            LOGGER.fine("[datafx] get the value of the task");
                            value = task.get();
                            LOGGER.log(Level.FINE, "[datafx] task returned value {0}", value);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            return;
                        }
                        catch (ExecutionException e) {
                            e.printStackTrace();
                            return;
                        }
                        LOGGER.log(Level.FINER, "[datafx] I will set the value of {0} to {1}", new Object[]{ObjectDataProvider.this.objectProperty, value});
                        System.out.println("DONE settting value");
                        LOGGER.log(Level.FINER, "Do we have a writeBackHandler? {0}", ObjectDataProvider.this.writeBackHandler);
                        if (ObjectDataProvider.this.writeBackHandler != null) {
                            ObjectDataProvider.this.checkProperties(value);
                        }
                        if (ObjectDataProvider.this.reader instanceof ServerSentEventReader) {
                            ObjectDataProvider.this.handleKeepReading((ServerSentEventReader)ObjectDataProvider.this.reader);
                        }
                    }
                });
                return task;
            }
        };
    }

    @Override
    public ObjectProperty<T> getData() {
        return this.objectProperty;
    }

    @Override
    public void setWriteBackHandler(WriteBackHandler<T> handler) {
        this.writeBackHandler = handler;
    }

    private void checkProperties(final T target) {
        Field[] fields;
        Class<?> c = target.getClass();
        for (final Field field : fields = c.getDeclaredFields()) {
            Class<?> clazz = field.getType();
            if (!Observable.class.isAssignableFrom(clazz)) continue;
            try {
                Observable observable = AccessController.doPrivileged(new PrivilegedAction<Observable>(){

                    @Override
                    public Observable run() {
                        try {
                            field.setAccessible(true);
                            Object f = field.get(target);
                            Observable answer = (Observable)f;
                            return answer;
                        }
                        catch (IllegalArgumentException ex) {
                            Logger.getLogger(ObjectDataProvider.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IllegalAccessException ex) {
                            Logger.getLogger(ObjectDataProvider.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        return null;
                    }
                });
                if (observable == null) continue;
                observable.addListener(new InvalidationListener(){

                    public void invalidated(final Observable o) {
                        final WritableDataReader reader = ObjectDataProvider.this.writeBackHandler.createDataSource(ObjectDataProvider.this.objectProperty.get());
                        Service service = new Service(){

                            protected Task createTask() {
                                Task task = new Task(){

                                    protected Object call() throws Exception {
                                        reader.writeBack();
                                        return o;
                                    }
                                };
                                return task;
                            }
                        };
                        if (ObjectDataProvider.this.executor != null) {
                            service.setExecutor(ObjectDataProvider.this.executor);
                        }
                        service.start();
                    }
                });
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(ObjectDataProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

