/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.io.converter;

import io.datafx.io.converter.InputStreamConverter;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class JsonConverter<T>
extends InputStreamConverter<T> {
    private JsonStructure rootNode;
    private final String tag;
    private final Class<T> clazz;
    private final ObjectMapper<T> objectMapper;
    private Iterator<JsonValue> iterator;
    private static final Logger LOGGER = Logger.getLogger(JsonConverter.class.getName());

    public JsonConverter(Class<T> clazz) {
        this(null, clazz);
    }

    public JsonConverter(String tag, Class<T> clazz) {
        this.tag = tag;
        this.clazz = clazz;
        this.objectMapper = new ObjectMapper<T>(clazz);
        LOGGER.fine("created Json Converter");
    }

    @Override
    public void initialize(InputStream input) {
        JsonValue tagValue;
        JsonObject rootNodeObject;
        LOGGER.fine("Initialize jsonConverter");
        JsonReader reader = Json.createReader((InputStream)input);
        this.rootNode = reader.read();
        LOGGER.fine("RootNode valuetype = " + this.rootNode.getValueType());
        if (this.rootNode.getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray rootNodeArray = (JsonArray)this.rootNode;
            this.iterator = rootNodeArray.iterator();
        } else if (this.tag != null && this.rootNode.getValueType() == JsonValue.ValueType.OBJECT && (rootNodeObject = (JsonObject)this.rootNode).containsKey((Object)this.tag) && (tagValue = (JsonValue)rootNodeObject.get((Object)this.tag)).getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray rootNodeArray = (JsonArray)tagValue;
            this.iterator = rootNodeArray.iterator();
        }
        LOGGER.fine("Inialized jsonconverter, rootNode = " + this.rootNode + " and iterator = " + this.iterator + " and tag = " + this.tag);
    }

    @Override
    public T get() {
        Object item;
        LOGGER.log(Level.FINER, "getting json data, tag = {0}", this.tag);
        if (this.tag == null) {
            item = ((ObjectMapper)this.objectMapper).readValue((JsonValue)this.rootNode);
        } else {
            JsonValue next = this.iterator.next();
            item = ((ObjectMapper)this.objectMapper).readValue(next);
        }
        LOGGER.log(Level.FINER, "did read Object {0}", item);
        return (T)item;
    }

    @Override
    public boolean next() {
        LOGGER.finer("Does json has next for tag " + this.tag);
        if (this.tag == null) {
            return false;
        }
        return this.iterator.hasNext();
    }

    static class ObjectMapper<T> {
        private final Class<T> clazz;
        private final Map<String, Method> settersMappedByPropertyName = new HashMap<String, Method>();
        private static final Map<Class, ObjectMapper> objectMappers = new HashMap<Class, ObjectMapper>();

        public ObjectMapper(Class<T> clazz) {
            this.clazz = clazz;
            objectMappers.put(clazz, this);
            this.resolveProperties();
        }

        private synchronized void resolveProperties() {
            Method[] methods = this.clazz.getMethods();
            Arrays.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method o1, Method o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            HashMap<String, Method> getters = new HashMap<String, Method>();
            for (Method method : methods) {
                XmlElement xmlElement;
                String annotatedName;
                Method getter;
                String bareMethodName;
                String methodName = method.getName();
                if (Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0 && !method.isAnnotationPresent(XmlTransient.class) && (methodName.matches("^get[A-Z].*") && !method.getReturnType().equals(Void.TYPE) || methodName.matches("^is[A-Z].*") && method.getReturnType().equals(Boolean.TYPE))) {
                    bareMethodName = methodName.startsWith("get") ? methodName.substring(3) : methodName.substring(2);
                    getters.put(bareMethodName, method);
                }
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1 || !method.getReturnType().equals(Void.TYPE) || method.isAnnotationPresent(XmlTransient.class) || !methodName.matches("^set[A-Z].*") || (getter = (Method)getters.get(bareMethodName = methodName.substring(3))) == null) continue;
                String finalName = bareMethodName.substring(0, 1).toLowerCase();
                if (bareMethodName.length() > 1) {
                    finalName = finalName + bareMethodName.substring(1);
                }
                if ((getter.isAnnotationPresent(XmlElement.class) || method.isAnnotationPresent(XmlElement.class)) && (annotatedName = (xmlElement = getter.isAnnotationPresent(XmlElement.class) ? getter.getAnnotation(XmlElement.class) : method.getAnnotation(XmlElement.class)).name()) != null && !annotatedName.isEmpty()) {
                    finalName = annotatedName;
                }
                this.settersMappedByPropertyName.put(finalName, method);
            }
        }

        private T readValue(JsonValue value) {
            try {
                T t = this.clazz.newInstance();
                if (value.getValueType() == JsonValue.ValueType.OBJECT) {
                    JsonObject object = (JsonObject)value;
                    for (String property : this.settersMappedByPropertyName.keySet()) {
                        LOGGER.fine("Check if the received object has a property named " + property);
                        if (!object.containsKey((Object)property)) continue;
                        LOGGER.fine("Yes, the received object has a property named " + property);
                        Method setter = this.settersMappedByPropertyName.get(property);
                        JsonValue propertyValue = (JsonValue)object.get((Object)property);
                        Object[] args = new Object[1];
                        switch (propertyValue.getValueType()) {
                            case NULL: {
                                args[0] = null;
                                break;
                            }
                            case FALSE: {
                                args[0] = Boolean.FALSE;
                                break;
                            }
                            case TRUE: {
                                args[0] = Boolean.TRUE;
                                break;
                            }
                            case STRING: {
                                JsonString stringProperty = (JsonString)propertyValue;
                                args[0] = stringProperty.getString();
                                break;
                            }
                            case NUMBER: {
                                String setterParameterTypeName;
                                JsonNumber numberProperty = (JsonNumber)propertyValue;
                                Class<?> setterParameterType = setter.getParameterTypes()[0];
                                if (setterParameterType.isArray()) break;
                                String string = setterParameterTypeName = setterParameterType.getName();
                                int n = -1;
                                switch (string.hashCode()) {
                                    case 3039496: {
                                        if (!string.equals("byte")) break;
                                        n = 0;
                                        break;
                                    }
                                    case 398507100: {
                                        if (!string.equals("java.lang.Byte")) break;
                                        n = 1;
                                        break;
                                    }
                                    case 104431: {
                                        if (!string.equals("int")) break;
                                        n = 2;
                                        break;
                                    }
                                    case -2056817302: {
                                        if (!string.equals("java.lang.Integer")) break;
                                        n = 3;
                                        break;
                                    }
                                    case 109413500: {
                                        if (!string.equals("short")) break;
                                        n = 4;
                                        break;
                                    }
                                    case -515992664: {
                                        if (!string.equals("java.lang.Short")) break;
                                        n = 5;
                                        break;
                                    }
                                    case 3327612: {
                                        if (!string.equals("long")) break;
                                        n = 6;
                                        break;
                                    }
                                    case 398795216: {
                                        if (!string.equals("java.lang.Long")) break;
                                        n = 7;
                                        break;
                                    }
                                    case -1325958191: {
                                        if (!string.equals("double")) break;
                                        n = 8;
                                        break;
                                    }
                                    case 761287205: {
                                        if (!string.equals("java.lang.Double")) break;
                                        n = 9;
                                        break;
                                    }
                                    case 97526364: {
                                        if (!string.equals("float")) break;
                                        n = 10;
                                        break;
                                    }
                                    case -527879800: {
                                        if (!string.equals("java.lang.Float")) break;
                                        n = 11;
                                        break;
                                    }
                                    case 1195259493: {
                                        if (!string.equals("java.lang.String")) break;
                                        n = 12;
                                        break;
                                    }
                                    case -2113502662: {
                                        if (!string.equals("javafx.beans.property.StringProperty")) break;
                                        n = 13;
                                    }
                                }
                                switch (n) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: {
                                        args[0] = numberProperty.intValue();
                                        break;
                                    }
                                    case 6: 
                                    case 7: {
                                        args[0] = numberProperty.longValue();
                                        break;
                                    }
                                    case 8: 
                                    case 9: {
                                        args[0] = numberProperty.doubleValue();
                                        break;
                                    }
                                    case 10: 
                                    case 11: {
                                        args[0] = Float.valueOf((float)numberProperty.doubleValue());
                                        break;
                                    }
                                    case 12: 
                                    case 13: {
                                        args[0] = numberProperty.toString();
                                    }
                                }
                                break;
                            }
                            case ARRAY: {
                                JsonArray arrayProperty = (JsonArray)propertyValue;
                                Class<ObservableList> parameterType = setter.getParameterTypes()[0];
                                Object values = parameterType.isAssignableFrom(ObservableList.class) ? FXCollections.observableArrayList() : new ArrayList();
                                block45: for (int i = 0; i < arrayProperty.size(); ++i) {
                                    JsonValue arrayValue = (JsonValue)arrayProperty.get(i);
                                    switch (arrayValue.getValueType()) {
                                        case NULL: {
                                            values.add(null);
                                            continue block45;
                                        }
                                        case FALSE: {
                                            values.add(Boolean.FALSE);
                                            continue block45;
                                        }
                                        case TRUE: {
                                            values.add(Boolean.TRUE);
                                            continue block45;
                                        }
                                        case STRING: {
                                            JsonString stringArrayValue = (JsonString)arrayValue;
                                            values.add(stringArrayValue.getString());
                                            continue block45;
                                        }
                                        case NUMBER: {
                                            JsonNumber numberArrayValue = (JsonNumber)arrayValue;
                                            if (numberArrayValue.isIntegral()) {
                                                values.add(numberArrayValue.longValue());
                                                continue block45;
                                            }
                                            values.add(numberArrayValue.doubleValue());
                                            continue block45;
                                        }
                                        case OBJECT: {
                                            System.out.println("ARRAYVAL = " + arrayValue);
                                            System.out.println("expected type = " + setter.getParameterTypes()[0]);
                                            Class<?> parameterTypes = setter.getParameterTypes()[0];
                                            parameterTypes.getAnnotations();
                                        }
                                        default: {
                                            throw new UnsupportedOperationException("Arrays or objects within arrays not yet supported.");
                                        }
                                    }
                                }
                                args[0] = values;
                                break;
                            }
                            case OBJECT: {
                                Class<?>[] p = setter.getParameterTypes();
                                if (p.length != 1) {
                                    LOGGER.info("We expect a single parameter when setting an object but we got " + p.length);
                                    break;
                                }
                                Class<?> subClazz = p[0];
                                ObjectMapper mapper = objectMappers.containsKey(subClazz) ? objectMappers.get(subClazz) : new ObjectMapper(subClazz);
                                args[0] = super.readValue(propertyValue);
                            }
                        }
                        try {
                            setter.invoke(t, args);
                        }
                        catch (IllegalArgumentException | InvocationTargetException ex) {
                            Logger.getLogger(JsonConverter.class.getName()).log(Level.SEVERE, "Failed to call setter " + setter + " with value " + propertyValue, ex);
                        }
                    }
                }
                return t;
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(JsonConverter.class.getName()).log(Level.SEVERE, "Could not instantiate object of type " + this.clazz, ex);
                return null;
            }
        }
    }
}

