/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.io.converter;

import io.datafx.io.Converter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class JdbcConverter<T>
implements Converter<ResultSet, T> {
    protected ResultSet resultSet;
    private boolean hasNext = true;

    @Override
    public void initialize(ResultSet input) throws IOException {
        this.resultSet = input;
        try {
            this.hasNext = this.resultSet.next();
        }
        catch (SQLException ex) {
            throw new IOException("Can't initialize Jdbc resultset", ex);
        }
    }

    @Override
    public T get() {
        T entry = this.convertOneRow(this.resultSet);
        try {
            this.hasNext = this.resultSet.next();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return entry;
    }

    public abstract T convertOneRow(ResultSet var1);

    @Override
    public boolean next() {
        try {
            int type = this.resultSet.getType();
            if (type == 1003) {
                return this.hasNext;
            }
            return !this.resultSet.isAfterLast();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

