/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.io;

import io.datafx.io.InputStreamDataReader;
import io.datafx.io.MultiValuedMap;
import io.datafx.io.OAuth;
import io.datafx.io.WritableDataReader;
import io.datafx.io.converter.InputStreamConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class RestSource<T>
extends InputStreamDataReader<T>
implements WritableDataReader<T> {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    private String host;
    private String path = "";
    private String consumerKey;
    private String consumerSecret;
    protected boolean requestMade;
    private Map<String, String> requestProperties;
    private Map<String, String> queryParams = new HashMap<String, String>();
    private MultiValuedMap formParams = new MultiValuedMap();
    private String dataString;
    private String requestMethod = null;
    private int timeout = -1;
    private String contentType;
    private IntegerProperty responseCode = new SimpleIntegerProperty(-1);
    private StringProperty responseMessage = new SimpleStringProperty();
    private static final Logger LOGGER = Logger.getLogger(RestSource.class.getName());

    public RestSource() {
    }

    public RestSource(String host, InputStreamConverter<T> converter) {
        super(converter);
        this.host = host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPath(String path) {
        this.path = path == null ? "" : (path.startsWith("/") ? path : "/" + path);
    }

    protected synchronized void createRequest() throws IOException {
        LOGGER.fine("RestSource will create request");
        if (this.requestMade) {
            return;
        }
        this.setInputStream(this.createInputStream());
        this.requestMade = true;
        LOGGER.fine("RestSource has created a request");
    }

    @Override
    public T get() throws IOException {
        LOGGER.log(Level.FINE, "[datafx] restsource will get a value, requestMade = {0}", this.requestMade);
        if (!this.requestMade) {
            this.createRequest();
        }
        if (this.getConverter() != null) {
            return super.get();
        }
        return null;
    }

    @Override
    public boolean next() {
        if (!this.requestMade) {
            try {
                this.createRequest();
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        return super.next();
    }

    public InputStream createInputStream() throws IOException {
        InputStream answer;
        String urlBase;
        String request = urlBase = this.host + this.path;
        String queryString = this.createQueryString();
        if (queryString != null) {
            request = request + "?" + queryString;
        }
        URL url = new URL(request);
        if (this.getRequestMethod() == null) {
            if (this.getFormParams().isEmpty() && this.getDataString() == null) {
                this.setRequestMethod(METHOD_GET);
            } else {
                this.setRequestMethod(METHOD_POST);
            }
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (this.getConsumerKey() != null) {
            try {
                MultiValuedMap allParams = new MultiValuedMap();
                allParams.putMap(this.getQueryParams());
                allParams.putAll(this.getFormParams());
                String string = OAuth.getHeader(this.getRequestMethod(), urlBase, allParams, this.getConsumerKey(), this.getConsumerSecret());
                connection.addRequestProperty("Authorization", string);
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(RestSource.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (GeneralSecurityException ex) {
                Logger.getLogger(RestSource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.getRequestMethod() != null) {
            connection.setRequestMethod(this.getRequestMethod());
        }
        if (this.timeout > -1) {
            connection.setReadTimeout(this.timeout);
            connection.setConnectTimeout(this.timeout);
        }
        if (this.getQueryParams() != null) {
            for (Map.Entry<String, String> entry : this.getQueryParams().entrySet()) {
                connection.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (this.getFormParams() != null && this.getFormParams().size() > 0) {
            if (this.dataString == null) {
                this.dataString = "";
            }
            boolean first = true;
            for (Map.Entry entry : this.getFormParams().entrySet()) {
                String key = (String)entry.getKey();
                for (String val : (List)entry.getValue()) {
                    if (val == null) {
                        throw new IllegalArgumentException("Values in form parameters can't be null -- was null for key " + key);
                    }
                    if (!first) {
                        this.dataString = this.dataString + "&";
                    } else {
                        first = false;
                    }
                    String eval = URLEncoder.encode(val, "UTF-8");
                    this.dataString = this.dataString + key + "=" + eval;
                }
            }
        }
        if (this.getDataString() != null) {
            connection.setDoOutput(true);
            if (this.contentType == null) {
                this.contentType = "application/x-www-form-urlencoded";
            }
            connection.setRequestProperty("Content-Type", this.contentType);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(connection.getOutputStream());
            Object var7_17 = null;
            try {
                outputStreamWriter.write(this.getDataString());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throw throwable;
            }
            finally {
                if (outputStreamWriter != null) {
                    if (var7_17 != null) {
                        try {
                            outputStreamWriter.close();
                        }
                        catch (Throwable throwable) {
                        }
                    } else {
                        outputStreamWriter.close();
                    }
                }
            }
        }
        try {
            InputStream inputStream = connection.getInputStream();
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 2);
            byte[] hdr = new byte[2];
            pushbackInputStream.read(hdr);
            pushbackInputStream.unread(hdr);
            answer = hdr[0] == 31 && hdr[1] == -117 ? new GZIPInputStream(pushbackInputStream) : pushbackInputStream;
        }
        catch (IOException iOException) {
            answer = connection.getErrorStream();
        }
        this.responseCode.set(connection.getResponseCode());
        this.responseMessage.set((Object)connection.getResponseMessage());
        return answer;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public Map<String, String> getRequestProperties() {
        return this.requestProperties;
    }

    public void setRequestProperties(Map<String, String> requestProperties) {
        this.requestProperties = requestProperties;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Map<String, String> queryParams) {
        if (queryParams != null) {
            this.queryParams = queryParams;
        }
    }

    private String createQueryString() {
        StringBuilder queryString = null;
        if (this.queryParams.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.queryParams.entrySet()) {
            if (queryString == null) {
                queryString = new StringBuilder(entry.getKey()).append("=").append(entry.getValue());
                continue;
            }
            queryString.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return queryString.toString();
    }

    public MultiValuedMap getFormParams() {
        return this.formParams;
    }

    public void setFormParams(Map<String, String> formParams) {
        this.formParams = new MultiValuedMap();
        for (Map.Entry<String, String> entry : formParams.entrySet()) {
            this.formParams.put(entry.getKey(), entry.getValue());
        }
    }

    public void setFormParams(MultiValuedMap formParams) {
        this.formParams = formParams;
    }

    public String getDataString() {
        return this.dataString;
    }

    public void setDataString(String dataString) {
        this.dataString = dataString;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    @Override
    public void writeBack() {
        try {
            this.createInputStream();
        }
        catch (Exception ex) {
            Logger.getLogger(RestSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int getResponseCode() {
        return this.responseCode.get();
    }

    public ReadOnlyIntegerProperty responseCodeProperty() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return (String)this.responseMessage.get();
    }

    public ReadOnlyStringProperty responseMessageProperty() {
        return this.responseMessage;
    }
}

