/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.crud.table;

import io.datafx.core.DataFXUtils;
import io.datafx.core.ExceptionHandler;
import io.datafx.crud.table.ViewColumn;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.TableColumn;

public class TableColumnFactory {
    public static <T> List<TableColumn<T, ?>> createColumns(Class<T> entityType) {
        return TableColumnFactory.createColumns(entityType, ExceptionHandler.getDefaultInstance());
    }

    public static <T> List<TableColumn<T, ?>> createColumns(Class<T> entityType, ExceptionHandler exceptionHandler) {
        ArrayList columns = new ArrayList();
        for (Field field : entityType.getDeclaredFields()) {
            ViewColumn columnAnnotation = field.getAnnotation(ViewColumn.class);
            if (columnAnnotation == null) continue;
            TableColumn column = new TableColumn();
            column.setText(columnAnnotation.value());
            column.setEditable(columnAnnotation.editable());
            column.setSortable(columnAnnotation.sortable());
            column.setResizable(columnAnnotation.resizeable());
            column.setCellValueFactory(e -> {
                try {
                    return new SimpleObjectProperty(DataFXUtils.getPrivileged((Field)field, (Object)e.getValue()));
                }
                catch (Exception exception) {
                    exceptionHandler.setException((Throwable)exception);
                    return null;
                }
            });
            columns.add(column);
        }
        return columns;
    }
}

