/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.crud.rest;

import io.datafx.crud.rest.RequestDataHandler;
import io.datafx.crud.util.Call;
import io.datafx.crud.util.HttpMethods;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.function.Function;

public class RestCall<S, T>
implements Call<S, T> {
    private Function<S, URL> urlFactory;
    private HttpMethods httpMethod;
    private RequestDataHandler<S> requestDataProvider;
    private Function<InputStream, T> responseDataHandler;

    public RestCall(Function<S, URL> urlFactory, HttpMethods httpMethod, RequestDataHandler<S> requestDataProvider, Function<InputStream, T> responseDataHandler) {
        this.httpMethod = httpMethod;
        this.requestDataProvider = requestDataProvider;
        this.responseDataHandler = responseDataHandler;
        this.urlFactory = urlFactory;
    }

    @Override
    public T call(S input) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.urlFactory.apply(input).openConnection();
        connection.setRequestMethod(this.httpMethod.toString());
        if (this.requestDataProvider != null) {
            this.requestDataProvider.writeData(input, connection.getOutputStream());
        }
        if (this.responseDataHandler != null) {
            return this.responseDataHandler.apply(connection.getInputStream());
        }
        return null;
    }
}

