/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.crud.jpa;

import io.datafx.crud.jpa.JpaCall;
import io.datafx.crud.util.EntityWithId;
import java.util.function.Supplier;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;

public class JpaDeleteCall<S extends EntityWithId<T>, T>
extends JpaCall<T, Void> {
    private Class<S> entityClass;

    public JpaDeleteCall(Supplier<EntityManager> managerSupplier, Class<S> entityClass) {
        super(managerSupplier);
        this.entityClass = entityClass;
    }

    public JpaDeleteCall(EntityManager manager, Class<S> entityClass) {
        this(() -> manager, entityClass);
    }

    @Override
    public Void call(T id) throws Exception {
        EntityTransaction transaction = this.getManager().getTransaction();
        try {
            transaction.begin();
            EntityWithId entity = (EntityWithId)this.getManager().find(this.entityClass, id);
            this.getManager().remove((Object)entity);
            transaction.commit();
            return null;
        }
        catch (PersistenceException e) {
            transaction.rollback();
            throw new PersistenceException("Rollback on entity delete", (Throwable)e);
        }
    }
}

