/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.crud.jpa;

import io.datafx.crud.BasicCrudService;
import io.datafx.crud.jpa.CreateOnceSupplier;
import io.datafx.crud.jpa.JpaDeleteCall;
import io.datafx.crud.jpa.JpaGetAllCall;
import io.datafx.crud.jpa.JpaGetByIdCall;
import io.datafx.crud.jpa.JpaPersistCall;
import io.datafx.crud.jpa.JpaUpdateCall;
import io.datafx.crud.util.EntityWithId;
import java.io.Serializable;
import java.util.function.Supplier;
import javax.persistence.EntityManager;

public class JpaCrudService<S extends EntityWithId<T>, T extends Serializable>
extends BasicCrudService<S, T> {
    private CreateOnceSupplier<EntityManager> entityManagerSupplier;
    private EntityManager createdManager;

    public JpaCrudService(EntityManager entityManager, Class<S> entityClass) {
        this(() -> entityManager, entityClass);
    }

    public JpaCrudService(Supplier<EntityManager> entityManagerSupplier, Class<S> entityClass) {
        this(new CreateOnceSupplier<EntityManager>(entityManagerSupplier), entityClass);
    }

    public JpaCrudService(CreateOnceSupplier<EntityManager> entityManagerSupplier, Class<S> entityClass) {
        super(new JpaGetAllCall(entityManagerSupplier, entityClass), new JpaGetByIdCall(entityManagerSupplier, entityClass), new JpaDeleteCall(entityManagerSupplier, entityClass), new JpaPersistCall(entityManagerSupplier), new JpaUpdateCall(entityManagerSupplier));
        this.entityManagerSupplier = entityManagerSupplier;
    }

    public EntityManager getEntityManager() {
        if (this.createdManager == null) {
            this.createdManager = this.entityManagerSupplier.get();
        }
        return this.createdManager;
    }
}

