/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.crud;

import io.datafx.core.concurrent.ConcurrentUtils;
import io.datafx.core.concurrent.ObservableExecutor;
import io.datafx.crud.CrudListProperty;
import io.datafx.crud.CrudService;
import io.datafx.crud.util.EntityWithId;
import java.util.concurrent.Executor;
import javafx.beans.property.SimpleObjectProperty;
import javafx.concurrent.Service;
import javafx.concurrent.Worker;

public class CrudObjectProperty<S extends EntityWithId<T>, T>
extends SimpleObjectProperty<S> {
    private CrudService<S, T> crudService;
    private Executor executor;
    private CrudListProperty<S, T> listProperty;

    public CrudObjectProperty(S entity, CrudListProperty<S, T> listProperty, CrudService<S, T> crudService) {
        this(entity, crudService, (Executor)ObservableExecutor.getDefaultInstance());
        this.listProperty = listProperty;
    }

    public CrudObjectProperty(S entity, CrudService<S, T> crudService) {
        this(crudService);
        this.set(entity);
    }

    public CrudObjectProperty(CrudService<S, T> crudService) {
        this(crudService, (Executor)ObservableExecutor.getDefaultInstance());
    }

    public CrudObjectProperty(S entity, CrudListProperty<S, T> listProperty, CrudService<S, T> crudService, Executor executor) {
        this(entity, crudService, executor);
        this.listProperty = listProperty;
    }

    public CrudObjectProperty(S entity, CrudService<S, T> crudService, Executor executor) {
        this(crudService, executor);
        this.set(entity);
    }

    private CrudObjectProperty(CrudService<S, T> crudService, Executor executor) {
        this.crudService = crudService;
        this.executor = executor;
    }

    public Worker<S> update() {
        return ConcurrentUtils.executeService((Executor)this.executor, (Service)ConcurrentUtils.createService(() -> {
            try {
                Object id = ConcurrentUtils.runCallableAndWait(() -> ((EntityWithId)this.get()).getId());
                S updatedData = this.crudService.getById(id);
                ConcurrentUtils.runAndWait(() -> this.set(updatedData));
                return updatedData;
            }
            catch (Exception e) {
                throw new RuntimeException("TODO", e);
            }
        }));
    }

    public Worker<S> save() {
        return ConcurrentUtils.executeService((Executor)this.executor, (Service)ConcurrentUtils.createService(() -> {
            try {
                EntityWithId updatedData = this.crudService.save((EntityWithId)this.get());
                ConcurrentUtils.runAndWait(() -> this.set(updatedData));
                return updatedData;
            }
            catch (Exception e) {
                throw new RuntimeException("TODO", e);
            }
        }));
    }

    public Worker<Void> delete() {
        return ConcurrentUtils.executeService((Executor)this.executor, (Service)ConcurrentUtils.createService(() -> {
            try {
                this.crudService.delete((EntityWithId)this.get());
                ConcurrentUtils.runAndWait(() -> {
                    this.set(null);
                    if (this.listProperty != null) {
                        this.listProperty.remove((Object)this);
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException("TODO", e);
            }
        }));
    }
}

