/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.crud;

import io.datafx.core.concurrent.ConcurrentUtils;
import io.datafx.core.concurrent.ObservableExecutor;
import io.datafx.crud.CrudObjectProperty;
import io.datafx.crud.CrudService;
import io.datafx.crud.util.EntityWithId;
import io.datafx.crud.util.QueryParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ModifiableObservableListBase;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;
import javafx.concurrent.Service;
import javafx.concurrent.Worker;

public class CrudListProperty<S extends EntityWithId<T>, T>
extends ModifiableObservableListBase<CrudObjectProperty<S, T>> {
    private CrudService<S, T> crudService;
    private Executor executor;
    private List<CrudObjectProperty<S, T>> innerList;
    private ObservableList<S> immutableEntityList;

    public CrudListProperty(CrudService<S, T> crudService) {
        this(crudService, (Executor)ObservableExecutor.getDefaultInstance());
    }

    public CrudListProperty(CrudService<S, T> crudService, Executor executor) {
        this.crudService = crudService;
        this.executor = executor;
        this.innerList = new ArrayList<CrudObjectProperty<S, T>>();
    }

    public ObservableList<S> getImmutableEntityList() {
        if (this.immutableEntityList == null) {
            this.immutableEntityList = new TransformationList<S, CrudObjectProperty<S, T>>((ObservableList)this){

                public boolean addAll(S ... elements) {
                    throw new UnsupportedOperationException();
                }

                public boolean setAll(S ... elements) {
                    throw new UnsupportedOperationException();
                }

                public boolean setAll(Collection<? extends S> col) {
                    throw new UnsupportedOperationException();
                }

                public boolean removeAll(S ... elements) {
                    throw new UnsupportedOperationException();
                }

                public boolean retainAll(S ... elements) {
                    throw new UnsupportedOperationException();
                }

                public void remove(int from, int to) {
                    throw new UnsupportedOperationException();
                }

                public S get(int index) {
                    return (EntityWithId)CrudListProperty.this.get(index).get();
                }

                public int size() {
                    return CrudListProperty.this.size();
                }

                protected void sourceChanged(ListChangeListener.Change<? extends CrudObjectProperty<S, T>> c) {
                    this.beginChange();
                    while (c.next()) {
                        if (c.wasPermutated()) {
                            int[] perm = new int[c.getTo() - c.getFrom() + 1];
                            int permIndex = 0;
                            int i = c.getFrom();
                            while (i <= c.getTo()) {
                                perm[permIndex] = i++;
                                ++permIndex;
                            }
                            this.nextPermutation(c.getFrom(), c.getTo(), perm);
                            continue;
                        }
                        if (c.wasUpdated()) {
                            this.nextUpdate(c.getFrom());
                            continue;
                        }
                        if (c.wasReplaced()) {
                            ArrayList<Object> replacedItems = new ArrayList<Object>();
                            for (CrudObjectProperty removedProperty : c.getRemoved()) {
                                replacedItems.add(removedProperty.get());
                            }
                            this.nextReplace(c.getFrom(), c.getTo(), replacedItems);
                            continue;
                        }
                        if (c.wasAdded()) {
                            this.nextAdd(c.getFrom(), c.getTo());
                            continue;
                        }
                        if (!c.wasRemoved()) continue;
                        ArrayList<Object> removedItems = new ArrayList<Object>();
                        for (CrudObjectProperty removedProperty : c.getRemoved()) {
                            removedItems.add(removedProperty.get());
                        }
                        this.nextRemove(c.getFrom(), removedItems);
                    }
                    this.endChange();
                }

                public int getSourceIndex(int index) {
                    return index;
                }
            };
        }
        return this.immutableEntityList;
    }

    public Worker<List<CrudObjectProperty<S, T>>> reload() {
        return this.innerReload(() -> this.crudService.getAll());
    }

    public Worker<List<CrudObjectProperty<S, T>>> reloadByQuery(String queryName, QueryParameter ... params) {
        return this.innerReload(() -> this.crudService.query(queryName, params));
    }

    private Worker<List<CrudObjectProperty<S, T>>> innerReload(Callable<List<S>> supplier) {
        return ConcurrentUtils.executeService((Executor)this.executor, (Service)ConcurrentUtils.createService(() -> {
            try {
                ObservableList newProperties = FXCollections.observableArrayList();
                List dataList = (List)supplier.call();
                for (EntityWithId data : dataList) {
                    newProperties.add(new CrudObjectProperty<EntityWithId, T>(data, this, this.crudService, this.executor));
                }
                ConcurrentUtils.runAndWait(() -> this.lambda$null$9((List)newProperties));
                return newProperties;
            }
            catch (Exception e) {
                throw new RuntimeException("TODO", e);
            }
        }));
    }

    public CrudObjectProperty<S, T> get(int index) {
        return this.innerList.get(index);
    }

    public int size() {
        return this.innerList.size();
    }

    protected void doAdd(int index, CrudObjectProperty<S, T> element) {
        this.innerList.add(index, element);
    }

    protected CrudObjectProperty<S, T> doSet(int index, CrudObjectProperty<S, T> element) {
        return this.innerList.set(index, element);
    }

    protected CrudObjectProperty<S, T> doRemove(int index) {
        return this.innerList.remove(index);
    }

    public void addAndSave(S entity) {
        CrudObjectProperty<S, T> p = new CrudObjectProperty<S, T>(entity, this, this.crudService);
        p.save();
        this.add(p);
    }

    private /* synthetic */ void lambda$null$9(List list) {
        this.setAll(list);
    }
}

