/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.core.concurrent;

import io.datafx.core.concurrent.Publisher;
import java.util.Arrays;
import javafx.application.Platform;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;

public abstract class PublishingTask<T>
extends Task<ObservableList<T>>
implements Publisher<T> {
    private final ObservableList<T> publishedValues;

    public PublishingTask() {
        this((ObservableList<T>)new SimpleListProperty(FXCollections.observableArrayList()));
    }

    public PublishingTask(ObservableList<T> values) {
        this.publishedValues = values;
    }

    public ObservableList<T> getPublishedValues() {
        return this.publishedValues;
    }

    protected final ObservableList<T> call() throws Exception {
        this.callTask();
        return this.publishedValues;
    }

    protected abstract void callTask() throws Exception;

    @Override
    public void publish(T ... values) {
        if (values != null && values.length > 0) {
            Platform.runLater(() -> this.publishedValues.addAll(Arrays.asList(values)));
        }
    }
}

