/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.core.concurrent;

import io.datafx.core.ExceptionHandler;
import io.datafx.core.concurrent.ConcurrentUtils;
import io.datafx.core.concurrent.ObservableExecutor;
import io.datafx.core.concurrent.ProcessDescription;
import io.datafx.core.concurrent.Publisher;
import io.datafx.core.concurrent.ThreadType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import javafx.util.Duration;

public class ProcessChain<T> {
    private List<ProcessDescription<?, ?>> processes;
    private Executor executorService;
    private ExceptionHandler exceptionHandler;
    private Runnable finalRunnable;

    public ProcessChain() {
        this(ObservableExecutor.getDefaultInstance());
    }

    public ProcessChain(Executor executorService) {
        this(executorService, null, null, null);
    }

    private ProcessChain(Executor executorService, List<ProcessDescription<?, ?>> processes, ExceptionHandler exceptionHandler, Runnable finalRunnable) {
        this.executorService = executorService;
        this.processes = new ArrayList();
        if (processes != null) {
            this.processes.addAll(processes);
        }
    }

    public static ProcessChain<Void> create() {
        return new ProcessChain<Void>();
    }

    public static ProcessChain<Void> create(Executor executorService) {
        return new ProcessChain<Void>(executorService);
    }

    public <V> ProcessChain<V> addFunction(Function<T, V> function, ThreadType type) {
        return this.addProcessDescription(new ProcessDescription<T, V>(function, type));
    }

    public <V> ProcessChain<V> addProcessDescription(ProcessDescription<T, V> processDescription) {
        this.processes.add(processDescription);
        return new ProcessChain<T>(this.executorService, this.processes, this.exceptionHandler, this.finalRunnable);
    }

    public <V> ProcessChain<V> addFunctionInPlatformThread(Function<T, V> function) {
        return this.addFunction(function, ThreadType.PLATFORM);
    }

    public <V> ProcessChain<V> addFunctionInExecutor(Function<T, V> function) {
        return this.addFunction(function, ThreadType.EXECUTOR);
    }

    public ProcessChain<Void> addRunnable(Runnable runnable, ThreadType type) {
        return this.addFunction(e -> {
            runnable.run();
            return null;
        }, type);
    }

    public ProcessChain<Void> addRunnableInPlatformThread(Runnable runnable) {
        return this.addRunnable(runnable, ThreadType.PLATFORM);
    }

    public ProcessChain<Void> addRunnableInExecutor(Runnable runnable) {
        return this.addRunnable(runnable, ThreadType.EXECUTOR);
    }

    public ProcessChain<Void> addConsumer(Consumer<T> consumer, ThreadType type) {
        return this.addFunction(e -> {
            consumer.accept(e);
            return null;
        }, type);
    }

    public ProcessChain<Void> addConsumerInPlatformThread(Consumer<T> consumer) {
        return this.addConsumer(consumer, ThreadType.PLATFORM);
    }

    public ProcessChain<Void> addConsumerInExecutor(Consumer<T> consumer) {
        return this.addConsumer(consumer, ThreadType.EXECUTOR);
    }

    public <V> ProcessChain<V> addSupplierInPlatformThread(Supplier<V> supplier) {
        return this.addSupplier(supplier, ThreadType.PLATFORM);
    }

    public <V> ProcessChain<V> addSupplierInExecutor(Supplier<V> supplier) {
        return this.addSupplier(supplier, ThreadType.EXECUTOR);
    }

    public <V> ProcessChain<V> addSupplier(Supplier<V> supplier, ThreadType type) {
        return this.addFunction(e -> supplier.get(), type);
    }

    public <V> ProcessChain<List<V>> addPublishingTask(Supplier<List<V>> supplier, Consumer<Publisher<V>> consumer) {
        return this.addFunction(e -> {
            List list = (List)supplier.get();
            Publisher<Object> publisher = p -> {
                try {
                    ConcurrentUtils.runAndWait(() -> list.addAll(Arrays.asList(p)));
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            };
            consumer.accept(publisher);
            return list;
        }, ThreadType.EXECUTOR);
    }

    public <V> ProcessChain<List<V>> addPublishingTask(List<V> list, Consumer<Publisher<V>> consumer) {
        return this.addPublishingTask(() -> list, consumer);
    }

    public <V> ProcessChain<List<V>> addPublishingTask(Consumer<Publisher<V>> consumer) {
        return this.addPublishingTask(() -> FXCollections.observableArrayList(), consumer);
    }

    public ProcessChain<T> onException(Consumer<Throwable> c) {
        this.exceptionHandler = new ExceptionHandler();
        this.exceptionHandler.exceptionProperty().addListener(e -> c.accept(this.exceptionHandler.getException()));
        return this;
    }

    public ProcessChain<T> onException(ExceptionHandler handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public ProcessChain<T> withFinal(Runnable finalRunnable) {
        this.finalRunnable = finalRunnable;
        return this;
    }

    private <U, V> V execute(U inputParameter, ProcessDescription<U, V> processDescription) throws InterruptedException, ExecutionException {
        if (processDescription.getThreadType().equals((Object)ThreadType.EXECUTOR)) {
            return processDescription.getFunction().apply(inputParameter);
        }
        return (V)ConcurrentUtils.runCallableAndWait(() -> processDescription.getFunction().apply(inputParameter));
    }

    public Task<T> repeatInfinite() {
        return this.repeat(Integer.MAX_VALUE);
    }

    public Task<T> repeatInfinite(Duration pauseTime) {
        return this.repeat(Integer.MAX_VALUE, pauseTime);
    }

    public Task<T> repeat(int count) {
        return this.repeat(count, Duration.ZERO);
    }

    public Task<T> repeat(final int count, final Duration pauseTime) {
        Task task = new Task<T>(){

            protected T call() throws Exception {
                try {
                    Object lastResult = null;
                    if (count == Integer.MAX_VALUE) {
                        while (true) {
                            lastResult = null;
                            for (ProcessDescription processDescription : ProcessChain.this.processes) {
                                lastResult = ProcessChain.this.execute(lastResult, processDescription);
                            }
                            Thread.sleep((long)pauseTime.toMillis());
                        }
                    }
                    for (int i = 0; i < count; ++i) {
                        lastResult = null;
                        for (ProcessDescription processDescription : ProcessChain.this.processes) {
                            lastResult = ProcessChain.this.execute(lastResult, processDescription);
                        }
                        Thread.sleep((long)pauseTime.toMillis());
                    }
                    Object object = lastResult;
                    return object;
                }
                catch (Exception e) {
                    if (ProcessChain.this.exceptionHandler != null) {
                        ConcurrentUtils.runAndWait(() -> ProcessChain.this.exceptionHandler.setException(e));
                    }
                    throw e;
                }
                finally {
                    if (ProcessChain.this.finalRunnable != null) {
                        ConcurrentUtils.runAndWait(() -> ProcessChain.this.finalRunnable.run());
                    }
                }
            }
        };
        this.executorService.execute((Runnable)task);
        return task;
    }

    public Task<T> run() {
        return this.repeat(1);
    }
}

