/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.core.concurrent;

import io.datafx.core.concurrent.CallableBasedDataFxTask;
import io.datafx.core.concurrent.DataFxService;
import io.datafx.core.concurrent.ObservableExecutor;
import io.datafx.core.concurrent.RunnableBasedDataFxTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;

public class ConcurrentUtils {
    private ConcurrentUtils() {
    }

    public static void runAndWait(Runnable runnable) throws InterruptedException, ExecutionException {
        FutureTask<Object> future = new FutureTask<Object>(runnable, null);
        Platform.runLater(future);
        future.get();
    }

    public static <T> T runCallableAndWait(Callable<T> callable) throws InterruptedException, ExecutionException {
        FutureTask<T> future = new FutureTask<T>(callable);
        Platform.runLater(future);
        return future.get();
    }

    public static DataFxService<Void> createService(Runnable runnable) {
        return ConcurrentUtils.createService(new RunnableBasedDataFxTask(runnable));
    }

    public static <T> DataFxService<T> createService(Callable<T> callable) {
        return ConcurrentUtils.createService(new CallableBasedDataFxTask<T>(callable));
    }

    public static <T> DataFxService<T> createService(final Task<T> task) {
        return new DataFxService<T>(){

            protected Task<T> createTask() {
                return task;
            }
        };
    }

    public static <T> Worker<T> executeService(Executor executor, Service<T> service) {
        if (executor != null && executor instanceof ObservableExecutor) {
            return ((ObservableExecutor)executor).submit(service);
        }
        if (executor != null) {
            service.setExecutor(executor);
        }
        service.start();
        return service;
    }

    public static <V> BooleanBinding isFinishedProperty(Worker<V> worker) {
        return worker.stateProperty().isEqualTo((Object)Worker.State.CANCELLED).or((ObservableBooleanValue)worker.stateProperty().isEqualTo((Object)Worker.State.FAILED).or((ObservableBooleanValue)worker.stateProperty().isEqualTo((Object)Worker.State.SUCCEEDED)));
    }

    public static <T> void then(Worker<T> worker, Consumer<T> consumer) {
        ReadOnlyBooleanProperty doneProperty = ConcurrentUtils.createIsDoneProperty(worker);
        ChangeListener listener = (o, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                consumer.accept(worker.getValue());
            }
        };
        doneProperty.addListener(listener);
    }

    public static ReadOnlyBooleanProperty createIsDoneProperty(Worker<?> worker) {
        SimpleBooleanProperty property = new SimpleBooleanProperty();
        Consumer<Worker.State> stateChecker = arg_0 -> ConcurrentUtils.lambda$createIsDoneProperty$17((BooleanProperty)property, arg_0);
        worker.stateProperty().addListener((o, oldValue, newValue) -> stateChecker.accept((Worker.State)newValue));
        stateChecker.accept(worker.getState());
        return property;
    }

    private static /* synthetic */ void lambda$createIsDoneProperty$17(BooleanProperty booleanProperty, Worker.State s) {
        if (s.equals((Object)Worker.State.CANCELLED) || s.equals((Object)Worker.State.FAILED) || s.equals((Object)Worker.State.SUCCEEDED)) {
            booleanProperty.setValue(Boolean.valueOf(true));
        } else {
            booleanProperty.setValue(Boolean.valueOf(false));
        }
    }
}

