/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.core;

import io.datafx.core.DataFXConfiguration;
import io.datafx.core.concurrent.ConcurrentUtils;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.concurrent.Worker;

public class ExceptionHandler {
    private static final Logger LOGGER = Logger.getLogger(ExceptionHandler.class.getName());
    private static ChangeListener<Throwable> loggerListener;
    private static ExceptionHandler defaultInstance;
    private static boolean logException;
    private ObjectProperty<Throwable> exception;

    public static synchronized ExceptionHandler getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new ExceptionHandler();
            ExceptionHandler.setExceptionLogging(DataFXConfiguration.getInstance().isExceptionLoggingActive());
        }
        return defaultInstance;
    }

    public static ChangeListener<Throwable> getLoggerListener() {
        if (loggerListener == null) {
            loggerListener = (ob, o, e) -> {
                if (e != null) {
                    if (e instanceof Exception) {
                        LOGGER.log(Level.SEVERE, "DataFX Exception Handler", (Exception)e);
                    } else {
                        LOGGER.log(Level.SEVERE, "DataFX Exception Handler: " + e.getMessage());
                    }
                }
            };
        }
        return loggerListener;
    }

    public static void setExceptionLogging(boolean log) {
        if (log) {
            ExceptionHandler.getDefaultInstance().exceptionProperty().addListener(ExceptionHandler.getLoggerListener());
        } else {
            ExceptionHandler.getDefaultInstance().exceptionProperty().removeListener(ExceptionHandler.getLoggerListener());
        }
        logException = log;
    }

    public static boolean isLogException() {
        return logException;
    }

    public Throwable getException() {
        return (Throwable)this.exceptionProperty().get();
    }

    public void setException(Throwable exception) {
        if (Platform.isFxApplicationThread()) {
            this.exceptionProperty().set((Object)exception);
        } else {
            try {
                ConcurrentUtils.runAndWait(() -> this.exceptionProperty().set((Object)exception));
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.log(Level.SEVERE, "Can't handle exception in JavaFX Application Thread!", e);
                LOGGER.log(Level.SEVERE, "Initial exception: ", exception);
            }
        }
    }

    public <T> void observeWorker(Worker<T> worker) {
        worker.exceptionProperty().addListener((ob, ol, e) -> this.setException((Throwable)e));
    }

    public ObjectProperty<Throwable> exceptionProperty() {
        if (this.exception == null) {
            this.exception = new SimpleObjectProperty();
        }
        return this.exception;
    }

    static {
        logException = false;
    }
}

