/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.core.concurrent;

import java.util.Arrays;
import javafx.application.Platform;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;

public abstract class PublishingTask<T>
extends Task<ObservableList<T>> {
    private final ObservableList<T> publishedValues;

    public PublishingTask() {
        this((ObservableList<T>)new SimpleListProperty(FXCollections.observableArrayList()));
    }

    public PublishingTask(ObservableList<T> values) {
        this.publishedValues = values;
    }

    public ObservableList<T> getPublishedValues() {
        return this.publishedValues;
    }

    protected final ObservableList<T> call() throws Exception {
        this.callTask();
        return this.publishedValues;
    }

    protected abstract void callTask() throws Exception;

    public void publish(final T ... values) {
        if (values != null && values.length > 0) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    PublishingTask.this.publishedValues.addAll(Arrays.asList(values));
                }
            });
        }
    }
}

