/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.core.concurrent;

import io.datafx.core.concurrent.ConcurrentUtils;
import io.datafx.core.concurrent.ProcessDescription;
import io.datafx.core.concurrent.ThreadType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.concurrent.Task;
import javafx.util.Duration;

public class ProcessChain<T> {
    private List<ProcessDescription<?, ?>> processes;
    private Executor executorService;

    public ProcessChain() {
        this(Executors.newCachedThreadPool(), null);
    }

    public ProcessChain(Executor executorService) {
        this(executorService, null);
    }

    private ProcessChain(Executor executorService, List<ProcessDescription<?, ?>> processes) {
        this.executorService = executorService;
        this.processes = new ArrayList();
        if (processes != null) {
            this.processes.addAll(processes);
        }
    }

    public static ProcessChain<Void> create() {
        return new ProcessChain<Void>();
    }

    public static ProcessChain<Void> create(Executor executorService) {
        return new ProcessChain<Void>(executorService);
    }

    public <V> ProcessChain<V> addFunction(Function<T, V> function, ThreadType type) {
        this.processes.add(new ProcessDescription<T, V>(function, type));
        return new ProcessChain<T>(this.executorService, this.processes);
    }

    public <V> ProcessChain<V> addFunctionInPlatformThread(Function<T, V> function) {
        return this.addFunction(function, ThreadType.PLATFORM);
    }

    public <V> ProcessChain<V> addFunctionInExecutor(Function<T, V> function) {
        return this.addFunction(function, ThreadType.EXECUTOR);
    }

    public ProcessChain<Void> addRunnable(Runnable runnable, ThreadType type) {
        return this.addFunction(e -> {
            runnable.run();
            return null;
        }, type);
    }

    public ProcessChain<Void> addRunnableInPlatformThread(Runnable runnable) {
        return this.addRunnable(runnable, ThreadType.PLATFORM);
    }

    public ProcessChain<Void> addRunnableInExecutor(Runnable runnable) {
        return this.addRunnable(runnable, ThreadType.EXECUTOR);
    }

    public ProcessChain<Void> addConsumer(Consumer<T> consumer, ThreadType type) {
        return this.addFunction(e -> {
            consumer.accept(e);
            return null;
        }, type);
    }

    public ProcessChain<Void> addConsumerInPlatformThread(Consumer<T> consumer) {
        return this.addConsumer(consumer, ThreadType.PLATFORM);
    }

    public ProcessChain<Void> addConsumerInExecutor(Consumer<T> consumer) {
        return this.addConsumer(consumer, ThreadType.EXECUTOR);
    }

    public <V> ProcessChain<V> addSupplierInPlatformThread(Supplier<V> supplier) {
        return this.addSupplier(supplier, ThreadType.PLATFORM);
    }

    public <V> ProcessChain<V> addSupplierInExecutor(Supplier<V> supplier) {
        return this.addSupplier(supplier, ThreadType.EXECUTOR);
    }

    public <V> ProcessChain<V> addSupplier(Supplier<V> supplier, ThreadType type) {
        return this.addFunction(e -> supplier.get(), type);
    }

    private <U, V> V execute(U inputParameter, ProcessDescription<U, V> processDescription, Executor executorService) throws InterruptedException, ExecutionException {
        if (processDescription.getThreadType().equals((Object)ThreadType.EXECUTOR)) {
            FutureTask<Object> task = new FutureTask<Object>(() -> processDescription.getFunction().apply(inputParameter));
            executorService.execute(task);
            return (V)task.get();
        }
        return (V)ConcurrentUtils.runCallableAndWait(() -> processDescription.getFunction().apply(inputParameter));
    }

    public Task<T> repeatInfinite() {
        return this.repeat(Integer.MAX_VALUE);
    }

    public Task<T> repeatInfinite(Duration pauseTime) {
        return this.repeat(Integer.MAX_VALUE, pauseTime);
    }

    public Task<T> repeat(int count) {
        return this.repeat(count, Duration.ZERO);
    }

    public Task<T> repeat(final int count, final Duration pauseTime) {
        Task task = new Task<T>(){

            protected T call() throws Exception {
                Object lastResult = null;
                if (count == Integer.MAX_VALUE) {
                    while (true) {
                        lastResult = null;
                        for (ProcessDescription processDescription : ProcessChain.this.processes) {
                            lastResult = ProcessChain.this.execute(lastResult, processDescription, ProcessChain.this.executorService);
                        }
                        Thread.sleep((long)pauseTime.toMillis());
                    }
                }
                for (int i = 0; i < count; ++i) {
                    lastResult = null;
                    for (ProcessDescription processDescription : ProcessChain.this.processes) {
                        lastResult = ProcessChain.this.execute(lastResult, processDescription, ProcessChain.this.executorService);
                    }
                    Thread.sleep((long)pauseTime.toMillis());
                }
                return lastResult;
            }
        };
        this.executorService.execute((Runnable)task);
        return task;
    }

    public Task<T> run() {
        Task task = new Task<T>(){

            protected T call() throws Exception {
                Object lastResult = null;
                for (ProcessDescription processDescription : ProcessChain.this.processes) {
                    lastResult = ProcessChain.this.execute(lastResult, processDescription, ProcessChain.this.executorService);
                }
                return lastResult;
            }
        };
        this.executorService.execute((Runnable)task);
        return task;
    }
}

