/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.core.concurrent;

import io.datafx.core.concurrent.CallableBasedDataFxTask;
import io.datafx.core.concurrent.ConcurrentUtils$$Lambda$1;
import io.datafx.core.concurrent.ConcurrentUtils$$Lambda$2;
import io.datafx.core.concurrent.ConcurrentUtils$$Lambda$3;
import io.datafx.core.concurrent.ConcurrentUtils$$Lambda$4;
import io.datafx.core.concurrent.DataFxService;
import io.datafx.core.concurrent.ObservableExecutor;
import io.datafx.core.concurrent.RunnableBasedDataFxTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;

public class ConcurrentUtils {
    private ConcurrentUtils() {
    }

    public static void runAndWait(Runnable runnable) throws InterruptedException, ExecutionException {
        FutureTask<Object> future = new FutureTask<Object>(runnable, null);
        Platform.runLater(future);
        future.get();
    }

    public static <T> T runCallableAndWait(Callable<T> callable) throws InterruptedException, ExecutionException {
        FutureTask<T> future = new FutureTask<T>(callable);
        Platform.runLater(future);
        return future.get();
    }

    public static DataFxService<Void> createService(Runnable runnable) {
        return ConcurrentUtils.createService(new RunnableBasedDataFxTask(runnable));
    }

    public static <T> DataFxService<T> createService(Callable<T> callable) {
        return ConcurrentUtils.createService(new CallableBasedDataFxTask<T>(callable));
    }

    public static <T> DataFxService<T> createService(final Task<T> task) {
        return new DataFxService<T>(){

            protected Task<T> createTask() {
                return task;
            }
        };
    }

    public static <T> Worker<T> executeService(Executor executor, Service<T> service) {
        if (executor != null && executor instanceof ObservableExecutor) {
            return ((ObservableExecutor)executor).submit(service);
        }
        if (executor != null) {
            service.setExecutor(executor);
        }
        service.start();
        return service;
    }

    public static <V> BooleanBinding isFinishedProperty(Worker<V> worker) {
        return worker.stateProperty().isEqualTo((Object)Worker.State.CANCELLED).or((ObservableBooleanValue)worker.stateProperty().isEqualTo((Object)Worker.State.FAILED).or((ObservableBooleanValue)worker.stateProperty().isEqualTo((Object)Worker.State.SUCCEEDED)));
    }

    public static <T> void then(Worker<T> worker, Consumer<T> consumer) {
        ReadOnlyBooleanProperty doneProperty = ConcurrentUtils.createIsDoneProperty(worker);
        ChangeListener listener = ConcurrentUtils$$Lambda$1.lambdaFactory$(consumer, worker);
        doneProperty.addListener(listener);
    }

    public static ReadOnlyBooleanProperty createIsDoneProperty(Worker<?> worker) {
        SimpleBooleanProperty property = new SimpleBooleanProperty();
        Consumer stateChecker = ConcurrentUtils$$Lambda$2.lambdaFactory$((BooleanProperty)property);
        worker.stateProperty().addListener(ConcurrentUtils$$Lambda$3.lambdaFactory$(stateChecker));
        stateChecker.accept(worker.getState());
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T waitFor(Worker<T> worker) throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        lock.lock();
        try {
            ReadOnlyBooleanProperty doneProperty = ConcurrentUtils.createIsDoneProperty(worker);
            if (doneProperty.get()) {
                Object object = worker.getValue();
                return (T)object;
            }
            doneProperty.addListener(ConcurrentUtils$$Lambda$4.lambdaFactory$(lock, condition));
            condition.await();
            Object object = worker.getValue();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$waitFor$28(Lock lock, Condition condition, Observable e) {
        boolean locked = lock.tryLock();
        if (locked) {
            try {
                condition.signal();
            }
            finally {
                lock.unlock();
            }
        } else {
            throw new RuntimeException("Concurreny Error");
        }
    }

    private static /* synthetic */ void lambda$createIsDoneProperty$26(BooleanProperty booleanProperty, Worker.State s) {
        if (s.equals((Object)Worker.State.CANCELLED) || s.equals((Object)Worker.State.FAILED) || s.equals((Object)Worker.State.SUCCEEDED)) {
            booleanProperty.setValue(Boolean.valueOf(true));
        } else {
            booleanProperty.setValue(Boolean.valueOf(false));
        }
    }

    private static /* synthetic */ void lambda$then$25(Consumer consumer, Worker worker, ObservableValue o, Boolean oldValue, Boolean newValue) {
        if (newValue.booleanValue()) {
            consumer.accept(worker.getValue());
        }
    }

    static /* synthetic */ void access$lambda$0(Consumer consumer, Worker worker, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        ConcurrentUtils.lambda$then$25(consumer, worker, observableValue, bl, bl2);
    }

    static /* synthetic */ void access$lambda$1(BooleanProperty booleanProperty, Worker.State state) {
        ConcurrentUtils.lambda$createIsDoneProperty$26(booleanProperty, state);
    }

    static /* synthetic */ void access$lambda$2(Consumer consumer, ObservableValue observableValue, Worker.State state, Worker.State state2) {
        consumer.accept(state2);
    }

    static /* synthetic */ void access$lambda$3(Lock lock, Condition condition, Observable observable) {
        ConcurrentUtils.lambda$waitFor$28(lock, condition, observable);
    }
}

