/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain.query.filters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import io.dapr.client.domain.query.filters.Filter;
import java.util.AbstractMap;
import java.util.Map;

public class EqFilter<T>
extends Filter<T> {
    @JsonValue
    private Map.Entry<String, T> eq;

    public EqFilter() {
        super("EQ");
    }

    public EqFilter(String key, T value) {
        super("EQ");
        this.eq = new AbstractMap.SimpleImmutableEntry<String, T>(key, value);
    }

    @JsonCreator
    EqFilter(Map.Entry<String, T> eq) {
        super("EQ");
        this.eq = eq;
    }

    @JsonIgnore
    public String getKey() {
        return this.eq != null ? this.eq.getKey() : null;
    }

    @JsonIgnore
    public T getValue() {
        return this.eq != null ? (T)this.eq.getValue() : null;
    }

    @Override
    public String getRepresentation() {
        return this.getKey() + " EQ " + this.getValue();
    }

    @Override
    public Boolean isValid() {
        return this.eq != null && this.eq.getKey() != null && !this.eq.getKey().isEmpty() && !this.eq.getKey().trim().isEmpty();
    }
}

