/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.utils;

import io.dapr.utils.Retry;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public final class NetworkUtils {
    private NetworkUtils() {
    }

    public static void waitForSocket(String host, int port, int timeoutInMilliseconds) throws InterruptedException {
        long started = System.currentTimeMillis();
        Retry.callWithRetry(() -> {
            try (Socket socket = new Socket();){
                int remainingTimeout = (int)Math.max(1L, (long)timeoutInMilliseconds - (System.currentTimeMillis() - started));
                socket.connect(new InetSocketAddress(host, port), remainingTimeout);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, timeoutInMilliseconds);
    }
}

