/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.internal.resiliency;

import io.dapr.config.Properties;
import io.grpc.CallOptions;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public final class TimeoutPolicy {
    private final Duration timeout;

    public TimeoutPolicy(Duration timeout) {
        this.timeout = timeout != null ? timeout : Properties.TIMEOUT.get();
    }

    public TimeoutPolicy() {
        this(null);
    }

    public CallOptions apply(CallOptions options) {
        if (this.timeout.isZero() || this.timeout.isNegative()) {
            return options;
        }
        return options.withDeadlineAfter(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
    }
}

