/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.internal.resiliency;

import io.dapr.config.Properties;
import io.dapr.exceptions.DaprException;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public final class RetryPolicy {
    private static final int MIN_BACKOFF_MILLIS = 500;
    private static final int MAX_BACKOFF_SECONDS = 5;
    private final Retry retrySpec;

    public RetryPolicy() {
        this(null);
    }

    public RetryPolicy(Integer maxRetries) {
        this.retrySpec = RetryPolicy.buildRetrySpec(maxRetries != null ? maxRetries : Properties.MAX_RETRIES.get());
    }

    public <T> Mono<T> apply(Mono<T> response) {
        if (this.retrySpec == null) {
            return response;
        }
        return response.retryWhen(this.retrySpec).onErrorMap(throwable -> RetryPolicy.findDaprException(throwable));
    }

    public <T> Flux<T> apply(Flux<T> response) {
        if (this.retrySpec == null) {
            return response;
        }
        return response.retryWhen(this.retrySpec).onErrorMap(throwable -> RetryPolicy.findDaprException(throwable));
    }

    private static Retry buildRetrySpec(int maxRetries) {
        if (maxRetries == 0) {
            return null;
        }
        if (maxRetries < 0) {
            return Retry.indefinitely().filter(throwable -> RetryPolicy.isRetryableGrpcError(throwable));
        }
        return Retry.backoff((long)maxRetries, (Duration)Duration.ofMillis(500L)).maxBackoff(Duration.ofSeconds(5L)).filter(throwable -> RetryPolicy.isRetryableGrpcError(throwable));
    }

    private static boolean isRetryableGrpcError(Throwable throwable) {
        Status grpcStatus = RetryPolicy.findGrpcStatusCode(throwable);
        if (grpcStatus == null) {
            return false;
        }
        switch (grpcStatus.getCode()) {
            case DEADLINE_EXCEEDED: 
            case UNAVAILABLE: {
                return true;
            }
        }
        return false;
    }

    private static Status findGrpcStatusCode(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof StatusRuntimeException) {
                return ((StatusRuntimeException)throwable).getStatus();
            }
            throwable = throwable.getCause();
        }
        return null;
    }

    private static Throwable findDaprException(Throwable throwable) {
        Throwable original = throwable;
        while (throwable != null) {
            if (throwable instanceof DaprException) {
                return throwable;
            }
            throwable = throwable.getCause();
        }
        return original;
    }
}

