/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.internal.opencensus;

import io.dapr.config.Property;
import io.dapr.internal.opencensus.BinaryFormatImpl;
import io.dapr.internal.opencensus.SpanContext;
import io.dapr.internal.opencensus.TraceContextFormat;
import io.dapr.v1.DaprGrpc;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public final class GrpcWrapper {
    private static final Logger LOGGER = Logger.getLogger(Property.class.getName());
    private static final BinaryFormatImpl OPENCENSUS_BINARY_FORMAT = new BinaryFormatImpl();
    private static final Metadata.Key<byte[]> GRPC_TRACE_BIN_KEY = Metadata.Key.of((String)"grpc-trace-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
    private static final Metadata.Key<String> TRACEPARENT_KEY = Metadata.Key.of((String)"traceparent", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> TRACESTATE_KEY = Metadata.Key.of((String)"tracestate", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    private GrpcWrapper() {
    }

    public static DaprGrpc.DaprStub intercept(final ContextView context, DaprGrpc.DaprStub client) {
        ClientInterceptor interceptor = new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
                ClientCall clientCall = channel.newCall(methodDescriptor, callOptions);
                return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(clientCall){

                    public void start(ClientCall.Listener<RespT> responseListener, Metadata metadata) {
                        SpanContext opencensusSpanContext;
                        Object value;
                        Map<String, Object> map = (context == null ? Context.empty() : context).stream().filter(e -> e.getKey() != null && e.getValue() != null).collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue()));
                        if (map.containsKey(GRPC_TRACE_BIN_KEY.name())) {
                            value = (byte[])map.get(GRPC_TRACE_BIN_KEY.name());
                            metadata.put(GRPC_TRACE_BIN_KEY, value);
                        }
                        if (map.containsKey(TRACEPARENT_KEY.name())) {
                            value = map.get(TRACEPARENT_KEY.name()).toString();
                            metadata.put(TRACEPARENT_KEY, value);
                        }
                        if (map.containsKey(TRACESTATE_KEY.name())) {
                            value = map.get(TRACESTATE_KEY.name()).toString();
                            metadata.put(TRACESTATE_KEY, value);
                        }
                        if ((opencensusSpanContext = GrpcWrapper.extractOpenCensusSpanContext(metadata)) != null) {
                            byte[] grpcTraceBin = OPENCENSUS_BINARY_FORMAT.toByteArray(opencensusSpanContext);
                            metadata.put(GRPC_TRACE_BIN_KEY, (Object)grpcTraceBin);
                        }
                        super.start(responseListener, metadata);
                    }
                };
            }
        };
        return (DaprGrpc.DaprStub)client.withInterceptors(new ClientInterceptor[]{interceptor});
    }

    private static SpanContext extractOpenCensusSpanContext(Metadata metadata) {
        if (!metadata.keys().contains(TRACEPARENT_KEY.name())) {
            return null;
        }
        try {
            return TraceContextFormat.extract(metadata);
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.FINE, "Could not extract span context.", e);
            return null;
        }
    }
}

