/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import io.dapr.client.DaprHttp;
import io.dapr.exceptions.DaprException;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

class GrpcChannelFacade
implements Closeable {
    private final ManagedChannel channel;
    private final DaprHttp daprHttp;

    GrpcChannelFacade(ManagedChannel channel, DaprHttp daprHttp) {
        this.channel = channel;
        this.daprHttp = daprHttp;
    }

    @Override
    public void close() throws IOException {
        if (this.daprHttp != null) {
            this.daprHttp.close();
        }
        if (this.channel != null && !this.channel.isShutdown()) {
            this.channel.shutdown();
        }
    }

    public Mono<Void> waitForChannelReady(int timeoutInMilliseconds) {
        String[] pathSegments = new String[]{"v1.0", "healthz", "outbound"};
        int maxRetries = 5;
        RetryBackoffSpec retrySpec = Retry.fixedDelay((long)maxRetries, (Duration)Duration.ofMillis(500L)).doBeforeRetry(retrySignal -> System.out.println("Retrying component health check..."));
        Mono<DaprHttp.Response> responseMono = this.daprHttp.invokeApi(DaprHttp.HttpMethods.GET.name(), pathSegments, null, "", null, null);
        return responseMono.retryWhen((Retry)retrySpec).timeout(Duration.ofMillis(timeoutInMilliseconds)).onErrorResume(DaprException.class, e -> Mono.error((Throwable)new RuntimeException((Throwable)e))).switchIfEmpty(DaprException.wrapMono(new RuntimeException("Health check timed out"))).then();
    }
}

