/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain;

import io.dapr.client.domain.StateOptions;
import java.util.Map;

public class State<T> {
    private final T value;
    private final String key;
    private final String etag;
    private final Map<String, String> metadata;
    private final String error;
    private final StateOptions options;

    public State(String key) {
        this.key = key;
        this.value = null;
        this.etag = null;
        this.metadata = null;
        this.options = null;
        this.error = null;
    }

    public State(String key, String etag, StateOptions options) {
        this.value = null;
        this.key = key;
        this.etag = etag;
        this.metadata = null;
        this.options = options;
        this.error = null;
    }

    public State(String key, T value, String etag, StateOptions options) {
        this.value = value;
        this.key = key;
        this.etag = etag;
        this.metadata = null;
        this.options = options;
        this.error = null;
    }

    public State(String key, T value, String etag, Map<String, String> metadata, StateOptions options) {
        this.value = value;
        this.key = key;
        this.etag = etag;
        this.metadata = metadata;
        this.options = options;
        this.error = null;
    }

    public State(String key, T value, String etag) {
        this.value = value;
        this.key = key;
        this.etag = etag;
        this.metadata = null;
        this.options = null;
        this.error = null;
    }

    public State(String key, String error) {
        this.value = null;
        this.key = key;
        this.etag = null;
        this.metadata = null;
        this.options = null;
        this.error = error;
    }

    public T getValue() {
        return this.value;
    }

    public String getKey() {
        return this.key;
    }

    public String getEtag() {
        return this.etag;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getError() {
        return this.error;
    }

    public StateOptions getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof State)) {
            return false;
        }
        State that = (State)o;
        if (this.getValue() != null ? !this.getValue().equals(that.getValue()) : that.getValue() != null) {
            return false;
        }
        if (this.getKey() != null ? !this.getKey().equals(that.getKey()) : that.getKey() != null) {
            return false;
        }
        if (this.getEtag() != null ? !this.getEtag().equals(that.getEtag()) : that.getEtag() != null) {
            return false;
        }
        if (this.getError() != null ? !this.getError().equals(that.getError()) : that.getError() != null) {
            return false;
        }
        if (this.getMetadata() != null ? !this.getMetadata().equals(that.getMetadata()) : that.getMetadata() != null) {
            return false;
        }
        return !(this.getOptions() != null ? !this.getOptions().equals(that.getOptions()) : that.getOptions() != null);
    }

    public int hashCode() {
        int result = this.getValue() != null ? this.getValue().hashCode() : 0;
        result = 31 * result + (this.getKey() != null ? this.getKey().hashCode() : 0);
        result = 31 * result + (this.getEtag() != null ? this.getEtag().hashCode() : 0);
        result = 31 * result + (this.getMetadata() != null ? this.getMetadata().hashCode() : 0);
        result = 31 * result + (this.getError() != null ? this.getError().hashCode() : 0);
        result = 31 * result + (this.getOptions() != null ? this.options.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StateKeyValue{key='" + this.key + "', value=" + this.value + ", etag='" + this.etag + "', metadata={'" + (this.metadata != null ? this.metadata.toString() : null) + "'}, error='" + this.error + "', options={'" + (this.options != null ? this.options.toString() : null) + "'}}";
    }
}

