/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import io.dapr.client.DaprHttp;
import io.dapr.config.Properties;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;

public class DaprHttpBuilder {
    private static final AtomicReference<OkHttpClient> OK_HTTP_CLIENT = new AtomicReference();
    private static final Object LOCK = new Object();

    public DaprHttp build() {
        return this.buildDaprHttp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DaprHttp buildDaprHttp() {
        if (OK_HTTP_CLIENT.get() == null) {
            Object object = LOCK;
            synchronized (object) {
                if (OK_HTTP_CLIENT.get() == null) {
                    OkHttpClient.Builder builder = new OkHttpClient.Builder();
                    Duration readTimeout = Duration.ofSeconds(Properties.HTTP_CLIENT_READ_TIMEOUT_SECONDS.get().intValue());
                    builder.readTimeout(readTimeout);
                    OkHttpClient okHttpClient = builder.build();
                    OK_HTTP_CLIENT.set(okHttpClient);
                }
            }
        }
        return new DaprHttp(Properties.SIDECAR_IP.get(), Properties.HTTP_PORT.get(), OK_HTTP_CLIENT.get());
    }
}

