/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.exceptions;

import io.dapr.exceptions.DaprError;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.Callable;
import reactor.core.publisher.Mono;

public class DaprException
extends RuntimeException {
    private String errorCode;

    public DaprException(DaprError daprError) {
        this(daprError.getErrorCode(), daprError.getMessage());
    }

    public DaprException(DaprError daprError, Exception cause) {
        this(daprError.getErrorCode(), daprError.getMessage(), cause);
    }

    public DaprException(Exception exception) {
        this("UNKNOWN", exception.getMessage(), exception);
    }

    public DaprException(String errorCode, String message) {
        super(String.format("%s: %s", errorCode, message));
        this.errorCode = errorCode;
    }

    public DaprException(String errorCode, String message, Exception cause) {
        super(String.format("%s: %s", errorCode, DaprException.emptyIfNull(message)), cause);
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public static void throwIllegalArgumentException(String message) {
        try {
            throw new IllegalArgumentException(message);
        }
        catch (Exception e) {
            DaprException.wrap(e);
            return;
        }
    }

    public static DaprException wrap(Exception exception) {
        if (exception == null) {
            return null;
        }
        if (exception instanceof DaprException) {
            throw (DaprException)exception;
        }
        for (Throwable e = exception; e != null; e = e.getCause()) {
            if (!(e instanceof StatusRuntimeException)) continue;
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)e;
            throw new DaprException(statusRuntimeException.getStatus().getCode().toString(), statusRuntimeException.getStatus().getDescription(), exception);
        }
        throw new DaprException(exception);
    }

    public static <T> Callable<T> wrap(Callable<T> callable) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                return DaprException.wrap(e);
            }
        };
    }

    public static <T> Mono<T> wrapMono(Exception exception) {
        try {
            DaprException.wrap(exception);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        return Mono.empty();
    }

    private static String emptyIfNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }
}

