/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain;

import io.dapr.client.domain.HttpExtension;
import io.dapr.client.domain.InvokeServiceRequest;
import io.opentelemetry.context.Context;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InvokeServiceRequestBuilder {
    private final String appId;
    private final String method;
    private String contentType;
    private Object body;
    private Map<String, String> metadata = new HashMap<String, String>();
    private HttpExtension httpExtension = HttpExtension.NONE;
    private Context context;

    public InvokeServiceRequestBuilder(String appId, String method) {
        this.appId = appId;
        this.method = method;
    }

    public InvokeServiceRequestBuilder withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public InvokeServiceRequestBuilder withBody(Object body) {
        this.body = body;
        return this;
    }

    public InvokeServiceRequestBuilder withMetadata(Map<String, String> metadata) {
        this.metadata = metadata == null ? null : Collections.unmodifiableMap(metadata);
        return this;
    }

    public InvokeServiceRequestBuilder withHttpExtension(HttpExtension httpExtension) {
        this.httpExtension = httpExtension;
        return this;
    }

    public InvokeServiceRequestBuilder withContext(Context context) {
        this.context = context;
        return this;
    }

    public InvokeServiceRequest build() {
        InvokeServiceRequest request = new InvokeServiceRequest();
        request.setAppId(this.appId);
        request.setContentType(this.contentType);
        request.setMethod(this.method);
        request.setBody(this.body);
        request.setHttpExtension(this.httpExtension);
        request.setMetadata(this.metadata);
        request.setContext(this.context);
        return request;
    }
}

