/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import io.dapr.client.DaprClient;
import io.dapr.client.DaprClientGrpc;
import io.dapr.client.DaprClientHttp;
import io.dapr.client.DaprHttpBuilder;
import io.dapr.config.Properties;
import io.dapr.exceptions.DaprException;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.serializer.DefaultObjectSerializer;
import io.dapr.v1.DaprGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.Closeable;

public class DaprClientBuilder {
    private final boolean useGrpc;
    private final DaprHttpBuilder daprHttpBuilder;
    private DaprObjectSerializer objectSerializer = new DefaultObjectSerializer();
    private DaprObjectSerializer stateSerializer = new DefaultObjectSerializer();

    public DaprClientBuilder() {
        this.useGrpc = Properties.USE_GRPC.get();
        this.daprHttpBuilder = new DaprHttpBuilder();
    }

    public DaprClientBuilder withObjectSerializer(DaprObjectSerializer objectSerializer) {
        if (objectSerializer == null) {
            DaprException.throwIllegalArgumentException("Object serializer is required");
        }
        if (objectSerializer.getContentType() == null || objectSerializer.getContentType().isEmpty()) {
            DaprException.throwIllegalArgumentException("Content Type should not be null or empty");
        }
        this.objectSerializer = objectSerializer;
        return this;
    }

    public DaprClientBuilder withStateSerializer(DaprObjectSerializer stateSerializer) {
        if (stateSerializer == null) {
            DaprException.throwIllegalArgumentException("State serializer is required");
        }
        this.stateSerializer = stateSerializer;
        return this;
    }

    public DaprClient build() {
        if (this.useGrpc) {
            return this.buildDaprClientGrpc();
        }
        return this.buildDaprClientHttp();
    }

    private DaprClient buildDaprClientGrpc() {
        int port = Properties.GRPC_PORT.get();
        if (port <= 0) {
            DaprException.throwIllegalArgumentException("Invalid port.");
        }
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)Properties.SIDECAR_IP.get(), (int)port).usePlaintext().build();
        Closeable closeableChannel = () -> {
            if (channel != null && !channel.isShutdown()) {
                channel.shutdown();
            }
        };
        DaprGrpc.DaprFutureStub stub = DaprGrpc.newFutureStub((Channel)channel);
        return new DaprClientGrpc(closeableChannel, stub, this.objectSerializer, this.stateSerializer);
    }

    private DaprClient buildDaprClientHttp() {
        return new DaprClientHttp(this.daprHttpBuilder.build(), this.objectSerializer, this.stateSerializer);
    }
}

