/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeRef<T> {
    public static final TypeRef<String> STRING = new TypeRef<String>(){};
    public static final TypeRef<Boolean> BOOLEAN = new TypeRef((Class)Boolean.TYPE){};
    public static final TypeRef<Integer> INT = new TypeRef((Class)Integer.TYPE){};
    public static final TypeRef<Long> LONG = new TypeRef((Class)Long.TYPE){};
    public static final TypeRef<Character> CHAR = new TypeRef((Class)Character.TYPE){};
    public static final TypeRef<Byte> BYTE = new TypeRef((Class)Byte.TYPE){};
    public static final TypeRef<Void> VOID = new TypeRef((Class)Void.TYPE){};
    public static final TypeRef<Float> FLOAT = new TypeRef((Class)Float.TYPE){};
    public static final TypeRef<Double> DOUBLE = new TypeRef((Class)Double.TYPE){};
    public static final TypeRef<byte[]> BYTE_ARRAY = new TypeRef<byte[]>(){};
    public static final TypeRef<int[]> INT_ARRAY = new TypeRef<int[]>(){};
    public static final TypeRef<String[]> STRING_ARRAY = new TypeRef<String[]>(){};
    private final Type type;

    public TypeRef() {
        Type superClass = this.getClass().getGenericSuperclass();
        if (superClass instanceof Class) {
            throw new IllegalArgumentException("TypeReference requires type.");
        }
        this.type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
    }

    private TypeRef(Class<T> clazz) {
        this.type = clazz;
    }

    public Type getType() {
        return this.type;
    }

    public static <T> TypeRef<T> get(Class<T> clazz) {
        if (clazz == String.class) {
            return STRING;
        }
        if (clazz == Boolean.TYPE) {
            return BOOLEAN;
        }
        if (clazz == Integer.TYPE) {
            return INT;
        }
        if (clazz == Long.TYPE) {
            return LONG;
        }
        if (clazz == Character.TYPE) {
            return CHAR;
        }
        if (clazz == Byte.TYPE) {
            return BYTE;
        }
        if (clazz == Void.TYPE) {
            return VOID;
        }
        if (clazz == Float.TYPE) {
            return FLOAT;
        }
        if (clazz == Double.TYPE) {
            return DOUBLE;
        }
        if (clazz == byte[].class) {
            return BYTE_ARRAY;
        }
        if (clazz == int[].class) {
            return INT_ARRAY;
        }
        if (clazz == String[].class) {
            return STRING_ARRAY;
        }
        return new TypeRef<T>((Class)clazz){};
    }
}

