/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import io.dapr.client.AbstractDaprClient;
import io.dapr.client.DaprHttp;
import io.dapr.client.ObjectSerializer;
import io.dapr.client.domain.DeleteStateRequest;
import io.dapr.client.domain.ExecuteStateTransactionRequest;
import io.dapr.client.domain.GetSecretRequest;
import io.dapr.client.domain.GetStateRequest;
import io.dapr.client.domain.GetStatesRequest;
import io.dapr.client.domain.HttpExtension;
import io.dapr.client.domain.InvokeBindingRequest;
import io.dapr.client.domain.InvokeServiceRequest;
import io.dapr.client.domain.PublishEventRequest;
import io.dapr.client.domain.Response;
import io.dapr.client.domain.SaveStateRequest;
import io.dapr.client.domain.State;
import io.dapr.client.domain.StateOptions;
import io.dapr.client.domain.TransactionalStateOperation;
import io.dapr.client.domain.TransactionalStateRequest;
import io.dapr.config.Properties;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.serializer.DefaultObjectSerializer;
import io.dapr.utils.TypeRef;
import io.grpc.Context;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import reactor.core.publisher.Mono;

public class DaprClientHttp
extends AbstractDaprClient {
    private static final String HEADER_HTTP_ETAG_ID = "If-Match";
    private static final ObjectSerializer INTERNAL_SERIALIZER = new ObjectSerializer();
    public static final String INVOKE_PATH = "v1.0/invoke";
    public static final String PUBLISH_PATH = "v1.0/publish";
    public static final String BINDING_PATH = "v1.0/bindings";
    public static final String STATE_PATH = "v1.0/state";
    private static final String TRANSACTION_URL_FORMAT = "v1.0/state/%s/transaction";
    public static final String SECRETS_PATH = "v1.0/secrets";
    public static final String STATE_BULK_PATH_FORMAT = "v1.0/state/%s/bulk";
    private final DaprHttp client;
    private final boolean isObjectSerializerDefault;
    private final boolean isStateSerializerDefault;

    DaprClientHttp(DaprHttp client, DaprObjectSerializer objectSerializer, DaprObjectSerializer stateSerializer) {
        super(objectSerializer, stateSerializer);
        this.client = client;
        this.isObjectSerializerDefault = objectSerializer.getClass() == DefaultObjectSerializer.class;
        this.isStateSerializerDefault = stateSerializer.getClass() == DefaultObjectSerializer.class;
    }

    DaprClientHttp(DaprHttp client) {
        this(client, new DefaultObjectSerializer(), new DefaultObjectSerializer());
    }

    @Override
    public Mono<Response<Void>> publishEvent(PublishEventRequest request) {
        try {
            String pubsubName = request.getPubsubName();
            String topic = request.getTopic();
            Object data = request.getData();
            Map<String, String> metadata = request.getMetadata();
            Context context = request.getContext();
            if (topic == null || topic.trim().isEmpty()) {
                throw new IllegalArgumentException("Topic name cannot be null or empty.");
            }
            StringBuilder url = new StringBuilder(PUBLISH_PATH).append("/").append(pubsubName).append("/").append(topic);
            byte[] serializedEvent = this.objectSerializer.serialize(data);
            return this.client.invokeApi(DaprHttp.HttpMethods.POST.name(), url.toString(), null, serializedEvent, metadata, context).thenReturn(new Response<Object>(context, null));
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public <T> Mono<Response<T>> invokeService(InvokeServiceRequest invokeServiceRequest, TypeRef<T> type) {
        try {
            String appId = invokeServiceRequest.getAppId();
            String method = invokeServiceRequest.getMethod();
            Object request = invokeServiceRequest.getBody();
            Map<String, String> metadata = invokeServiceRequest.getMetadata();
            HttpExtension httpExtension = invokeServiceRequest.getHttpExtension();
            Context context = invokeServiceRequest.getContext();
            if (httpExtension == null) {
                throw new IllegalArgumentException("HttpExtension cannot be null. Use HttpExtension.NONE instead.");
            }
            String httMethod = httpExtension.getMethod().toString();
            if (appId == null || appId.trim().isEmpty()) {
                throw new IllegalArgumentException("App Id cannot be null or empty.");
            }
            if (method == null || method.trim().isEmpty()) {
                throw new IllegalArgumentException("Method name cannot be null or empty.");
            }
            String path = String.format("%s/%s/method/%s", INVOKE_PATH, appId, method);
            byte[] serializedRequestBody = this.objectSerializer.serialize(request);
            Mono<DaprHttp.Response> response = this.client.invokeApi(httMethod, path, httpExtension.getQueryString(), serializedRequestBody, metadata, context);
            return response.flatMap(r -> {
                try {
                    Object object = this.objectSerializer.deserialize(r.getBody(), type);
                    if (object == null) {
                        return Mono.empty();
                    }
                    return Mono.just(object);
                }
                catch (Exception ex) {
                    return Mono.error((Throwable)ex);
                }
            }).map(r -> new Response<Object>(context, r));
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public <T> Mono<Response<T>> invokeBinding(InvokeBindingRequest request, TypeRef<T> type) {
        try {
            String name = request.getName();
            String operation = request.getOperation();
            Object data = request.getData();
            Map<String, String> metadata = request.getMetadata();
            Context context = request.getContext();
            if (name == null || name.trim().isEmpty()) {
                throw new IllegalArgumentException("Binding name cannot be null or empty.");
            }
            if (operation == null || operation.trim().isEmpty()) {
                throw new IllegalArgumentException("Binding operation cannot be null or empty.");
            }
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("operation", operation);
            if (metadata != null) {
                jsonMap.put("metadata", metadata);
            }
            if (data != null) {
                if (this.isObjectSerializerDefault) {
                    jsonMap.put("data", data);
                } else {
                    jsonMap.put("data", this.objectSerializer.serialize(data));
                }
            }
            StringBuilder url = new StringBuilder(BINDING_PATH).append("/").append(name);
            byte[] payload = INTERNAL_SERIALIZER.serialize(jsonMap);
            String httpMethod = DaprHttp.HttpMethods.POST.name();
            Mono<DaprHttp.Response> response = this.client.invokeApi(httpMethod, url.toString(), null, payload, null, context);
            return response.flatMap(r -> {
                try {
                    Object object = this.objectSerializer.deserialize(r.getBody(), type);
                    if (object == null) {
                        return Mono.empty();
                    }
                    return Mono.just(object);
                }
                catch (Exception ex) {
                    return Mono.error((Throwable)ex);
                }
            }).map(r -> new Response<Object>(context, r));
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public <T> Mono<Response<List<State<T>>>> getStates(GetStatesRequest request, TypeRef<T> type) {
        try {
            String stateStoreName = request.getStateStoreName();
            List<String> keys = request.getKeys();
            int parallelism = request.getParallelism();
            Context context = request.getContext();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (keys == null || keys.isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            if (parallelism < 0) {
                throw new IllegalArgumentException("Parallelism cannot be negative.");
            }
            String url = String.format(STATE_BULK_PATH_FORMAT, stateStoreName);
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("keys", keys);
            jsonMap.put("parallelism", parallelism);
            byte[] requestBody = INTERNAL_SERIALIZER.serialize(jsonMap);
            return this.client.invokeApi(DaprHttp.HttpMethods.POST.name(), url, null, requestBody, null, context).flatMap(s -> {
                try {
                    return Mono.just(this.buildStates((DaprHttp.Response)s, type));
                }
                catch (Exception ex) {
                    return Mono.error((Throwable)ex);
                }
            }).map(r -> new Response<List>(context, (List)r));
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public <T> Mono<Response<State<T>>> getState(GetStateRequest request, TypeRef<T> type) {
        try {
            String stateStoreName = request.getStateStoreName();
            String key = request.getKey();
            StateOptions options = request.getStateOptions();
            String etag = request.getEtag();
            Context context = request.getContext();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            if (etag != null && !etag.trim().isEmpty()) {
                headers.put(HEADER_HTTP_ETAG_ID, etag);
            }
            StringBuilder url = new StringBuilder(STATE_PATH).append("/").append(stateStoreName).append("/").append(key);
            Map urlParameters = Optional.ofNullable(options).map(o -> o.getStateOptionsAsMap()).orElse(new HashMap());
            request.getMetadata().forEach(urlParameters::put);
            return this.client.invokeApi(DaprHttp.HttpMethods.GET.name(), url.toString(), urlParameters, headers, context).flatMap(s -> {
                try {
                    return Mono.just(this.buildState((DaprHttp.Response)s, key, options, type));
                }
                catch (Exception ex) {
                    return Mono.error((Throwable)ex);
                }
            }).map(r -> new Response<State>(context, (State)r));
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public Mono<Response<Void>> executeTransaction(ExecuteStateTransactionRequest request) {
        try {
            String stateStoreName = request.getStateStoreName();
            List<TransactionalStateOperation<?>> operations = request.getOperations();
            Map<String, String> metadata = request.getMetadata();
            Context context = request.getContext();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (operations == null || operations.isEmpty()) {
                return Mono.empty();
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            String etag = operations.stream().filter(op -> null != op.getRequest().getEtag() && !op.getRequest().getEtag().trim().isEmpty()).findFirst().orElse(new TransactionalStateOperation<Object>(null, new State<Object>(null, null, null, null))).getRequest().getEtag();
            if (etag != null && !etag.trim().isEmpty()) {
                headers.put(HEADER_HTTP_ETAG_ID, etag);
            }
            String url = String.format(TRANSACTION_URL_FORMAT, stateStoreName);
            ArrayList internalOperationObjects = new ArrayList(operations.size());
            for (TransactionalStateOperation<?> operation : operations) {
                State<?> state = operation.getRequest();
                if (state == null) continue;
                if (this.isStateSerializerDefault) {
                    internalOperationObjects.add(operation);
                    continue;
                }
                byte[] data = this.stateSerializer.serialize(state.getValue());
                operations.add(new TransactionalStateOperation<byte[]>(operation.getOperation(), new State<byte[]>(data, state.getKey(), state.getEtag(), state.getOptions())));
            }
            TransactionalStateRequest req = new TransactionalStateRequest(internalOperationObjects, metadata);
            byte[] serializedOperationBody = INTERNAL_SERIALIZER.serialize(req);
            return this.client.invokeApi(DaprHttp.HttpMethods.POST.name(), url, null, serializedOperationBody, headers, context).thenReturn(new Response<Object>(context, null));
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<Response<Void>> saveStates(SaveStateRequest request) {
        try {
            String stateStoreName = request.getStateStoreName();
            List<State<?>> states = request.getStates();
            Context context = request.getContext();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (states == null || states.isEmpty()) {
                return Mono.empty();
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            String etag = states.stream().filter(state -> null != state.getEtag() && !state.getEtag().trim().isEmpty()).findFirst().orElse(new State<Object>(null, null, null, null)).getEtag();
            if (etag != null && !etag.trim().isEmpty()) {
                headers.put(HEADER_HTTP_ETAG_ID, etag);
            }
            String url = "v1.0/state/" + stateStoreName;
            ArrayList internalStateObjects = new ArrayList(states.size());
            for (State<?> state2 : states) {
                if (state2 == null) continue;
                if (this.isStateSerializerDefault) {
                    internalStateObjects.add(state2);
                    continue;
                }
                byte[] data = this.stateSerializer.serialize(state2.getValue());
                internalStateObjects.add(new State<byte[]>(data, state2.getKey(), state2.getEtag(), state2.getOptions()));
            }
            byte[] serializedStateBody = INTERNAL_SERIALIZER.serialize(internalStateObjects);
            return this.client.invokeApi(DaprHttp.HttpMethods.POST.name(), url, null, serializedStateBody, headers, context).thenReturn(new Response<Object>(context, null));
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public Mono<Response<Void>> deleteState(DeleteStateRequest request) {
        try {
            String stateStoreName = request.getStateStoreName();
            String key = request.getKey();
            StateOptions options = request.getStateOptions();
            String etag = request.getEtag();
            Context context = request.getContext();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            if (etag != null && !etag.trim().isEmpty()) {
                headers.put(HEADER_HTTP_ETAG_ID, etag);
            }
            String url = "v1.0/state/" + stateStoreName + "/" + key;
            Map urlParameters = Optional.ofNullable(options).map(stateOptions -> stateOptions.getStateOptionsAsMap()).orElse(new HashMap());
            request.getMetadata().forEach(urlParameters::put);
            return this.client.invokeApi(DaprHttp.HttpMethods.DELETE.name(), url, urlParameters, headers, context).thenReturn(new Response<Object>(context, null));
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    private <T> State<T> buildState(DaprHttp.Response response, String requestedKey, StateOptions stateOptions, TypeRef<T> type) throws IOException {
        T value = this.stateSerializer.deserialize(response.getBody(), type);
        String key = requestedKey;
        String etag = null;
        if (response.getHeaders() != null && response.getHeaders().containsKey("Etag")) {
            etag = response.getHeaders().get("Etag");
        }
        return new State<T>(value, key, etag, stateOptions);
    }

    private <T> List<State<T>> buildStates(DaprHttp.Response response, TypeRef<T> type) throws IOException {
        JsonNode root = INTERNAL_SERIALIZER.parseNode(response.getBody());
        ArrayList<State<T>> result = new ArrayList<State<T>>();
        Iterator it = root.elements();
        while (it.hasNext()) {
            JsonNode node = (JsonNode)it.next();
            String key = node.path("key").asText();
            String error = node.path("error").asText();
            if (!Strings.isNullOrEmpty((String)error)) {
                result.add(new State(key, error));
                continue;
            }
            String etag = node.path("etag").asText();
            byte[] data = node.path("data").toString().getBytes(Properties.STRING_CHARSET.get());
            T value = this.stateSerializer.deserialize(data, type);
            result.add(new State<T>(value, key, etag));
        }
        return result;
    }

    @Override
    public Mono<Response<Map<String, String>>> getSecret(GetSecretRequest request) {
        String secretStoreName = request.getSecretStoreName();
        String key = request.getKey();
        Map<String, String> metadata = request.getMetadata();
        Context context = request.getContext();
        try {
            if (secretStoreName == null || secretStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("Secret store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Secret key cannot be null or empty.");
            }
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        String url = "v1.0/secrets/" + secretStoreName + "/" + key;
        return this.client.invokeApi(DaprHttp.HttpMethods.GET.name(), url, metadata, (String)null, null, context).flatMap(response -> {
            try {
                Map m = INTERNAL_SERIALIZER.deserialize(response.getBody(), Map.class);
                if (m == null) {
                    return Mono.just((Object)Collections.EMPTY_MAP);
                }
                return Mono.just((Object)m);
            }
            catch (IOException e) {
                return Mono.error((Throwable)e);
            }
        }).map(m -> m).map(m -> new Response<Map>(context, (Map)m));
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

