/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import io.dapr.client.AbstractDaprClient;
import io.dapr.client.domain.DeleteStateRequest;
import io.dapr.client.domain.ExecuteStateTransactionRequest;
import io.dapr.client.domain.GetSecretRequest;
import io.dapr.client.domain.GetStateRequest;
import io.dapr.client.domain.GetStatesRequest;
import io.dapr.client.domain.HttpExtension;
import io.dapr.client.domain.InvokeBindingRequest;
import io.dapr.client.domain.InvokeServiceRequest;
import io.dapr.client.domain.PublishEventRequest;
import io.dapr.client.domain.Response;
import io.dapr.client.domain.SaveStateRequest;
import io.dapr.client.domain.State;
import io.dapr.client.domain.StateOptions;
import io.dapr.client.domain.TransactionalStateOperation;
import io.dapr.config.Properties;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.utils.TypeRef;
import io.dapr.v1.CommonProtos;
import io.dapr.v1.DaprGrpc;
import io.dapr.v1.DaprProtos;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.opencensus.implcore.trace.propagation.PropagationComponentImpl;
import io.opencensus.implcore.trace.propagation.TraceContextFormat;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.propagation.BinaryFormat;
import io.opencensus.trace.propagation.SpanContextParseException;
import io.opencensus.trace.propagation.TextFormat;
import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.context.propagation.HttpTextFormat;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

public class DaprClientGrpc
extends AbstractDaprClient {
    private static final BinaryFormat OPENCENSUS_BINARY_FORMAT = new PropagationComponentImpl().getBinaryFormat();
    private Closeable channel;
    private DaprGrpc.DaprFutureStub client;

    DaprClientGrpc(Closeable closeableChannel, DaprGrpc.DaprFutureStub futureClient, DaprObjectSerializer objectSerializer, DaprObjectSerializer stateSerializer) {
        super(objectSerializer, stateSerializer);
        this.channel = closeableChannel;
        this.client = DaprClientGrpc.populateWithInterceptors(futureClient);
    }

    private CommonProtos.StateOptions.StateConsistency getGrpcStateConsistency(StateOptions options) {
        switch (options.getConsistency()) {
            case EVENTUAL: {
                return CommonProtos.StateOptions.StateConsistency.CONSISTENCY_EVENTUAL;
            }
            case STRONG: {
                return CommonProtos.StateOptions.StateConsistency.CONSISTENCY_STRONG;
            }
        }
        throw new IllegalArgumentException("Missing Consistency mapping to gRPC Consistency enum");
    }

    private CommonProtos.StateOptions.StateConcurrency getGrpcStateConcurrency(StateOptions options) {
        switch (options.getConcurrency()) {
            case FIRST_WRITE: {
                return CommonProtos.StateOptions.StateConcurrency.CONCURRENCY_FIRST_WRITE;
            }
            case LAST_WRITE: {
                return CommonProtos.StateOptions.StateConcurrency.CONCURRENCY_LAST_WRITE;
            }
        }
        throw new IllegalArgumentException("Missing StateConcurrency mapping to gRPC Concurrency enum");
    }

    @Override
    public Mono<Response<Void>> publishEvent(PublishEventRequest request) {
        try {
            String pubsubName = request.getPubsubName();
            String topic = request.getTopic();
            Object data = request.getData();
            Context context = request.getContext();
            DaprProtos.PublishEventRequest envelope = DaprProtos.PublishEventRequest.newBuilder().setTopic(topic).setPubsubName(pubsubName).setData(ByteString.copyFrom((byte[])this.objectSerializer.serialize(data))).build();
            return Mono.fromCallable(DaprClientGrpc.wrap(context, () -> {
                ListenableFuture futureEmpty = this.client.publishEvent(envelope);
                futureEmpty.get();
                return null;
            }));
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public <T> Mono<Response<T>> invokeService(InvokeServiceRequest invokeServiceRequest, TypeRef<T> type) {
        try {
            String appId = invokeServiceRequest.getAppId();
            String method = invokeServiceRequest.getMethod();
            Object request = invokeServiceRequest.getBody();
            HttpExtension httpExtension = invokeServiceRequest.getHttpExtension();
            Context context = invokeServiceRequest.getContext();
            DaprProtos.InvokeServiceRequest envelope = this.buildInvokeServiceRequest(httpExtension, appId, method, request);
            return Mono.fromCallable(DaprClientGrpc.wrap(context, () -> {
                ListenableFuture futureResponse = this.client.invokeService(envelope);
                return this.objectSerializer.deserialize(((CommonProtos.InvokeResponse)futureResponse.get()).getData().getValue().toByteArray(), type);
            })).map(r -> new Response<Object>(context, r));
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public <T> Mono<Response<T>> invokeBinding(InvokeBindingRequest request, TypeRef<T> type) {
        try {
            String name = request.getName();
            String operation = request.getOperation();
            Object data = request.getData();
            Map<String, String> metadata = request.getMetadata();
            Context context = request.getContext();
            if (name == null || name.trim().isEmpty()) {
                throw new IllegalArgumentException("Binding name cannot be null or empty.");
            }
            if (operation == null || operation.trim().isEmpty()) {
                throw new IllegalArgumentException("Binding operation cannot be null or empty.");
            }
            byte[] byteData = this.objectSerializer.serialize(data);
            DaprProtos.InvokeBindingRequest.Builder builder = DaprProtos.InvokeBindingRequest.newBuilder().setName(name).setOperation(operation);
            if (byteData != null) {
                builder.setData(ByteString.copyFrom((byte[])byteData));
            }
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            DaprProtos.InvokeBindingRequest envelope = builder.build();
            return Mono.fromCallable(DaprClientGrpc.wrap(context, () -> {
                ListenableFuture futureResponse = this.client.invokeBinding(envelope);
                return this.objectSerializer.deserialize(((DaprProtos.InvokeBindingResponse)futureResponse.get()).getData().toByteArray(), type);
            })).map(r -> new Response<Object>(context, r));
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public <T> Mono<Response<State<T>>> getState(GetStateRequest request, TypeRef<T> type) {
        try {
            String stateStoreName = request.getStateStoreName();
            String key = request.getKey();
            StateOptions options = request.getStateOptions();
            Context context = request.getContext();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            DaprProtos.GetStateRequest.Builder builder = DaprProtos.GetStateRequest.newBuilder().setStoreName(stateStoreName).setKey(key).putAllMetadata(request.getMetadata());
            if (options != null && options.getConsistency() != null) {
                builder.setConsistency(this.getGrpcStateConsistency(options));
            }
            DaprProtos.GetStateRequest envelope = builder.build();
            return Mono.fromCallable(DaprClientGrpc.wrap(context, () -> {
                ListenableFuture futureResponse = this.client.getState(envelope);
                DaprProtos.GetStateResponse response = null;
                try {
                    response = (DaprProtos.GetStateResponse)futureResponse.get();
                }
                catch (NullPointerException npe) {
                    return null;
                }
                return this.buildStateKeyValue(response, key, options, type);
            })).map(s -> new Response<State>(context, (State)s));
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public <T> Mono<Response<List<State<T>>>> getStates(GetStatesRequest request, TypeRef<T> type) {
        try {
            String stateStoreName = request.getStateStoreName();
            List<String> keys = request.getKeys();
            int parallelism = request.getParallelism();
            Context context = request.getContext();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (keys == null || keys.isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            if (parallelism < 0) {
                throw new IllegalArgumentException("Parallelism cannot be negative.");
            }
            DaprProtos.GetBulkStateRequest.Builder builder = DaprProtos.GetBulkStateRequest.newBuilder().setStoreName(stateStoreName).addAllKeys(keys).setParallelism(parallelism);
            DaprProtos.GetBulkStateRequest envelope = builder.build();
            return Mono.fromCallable(DaprClientGrpc.wrap(context, () -> {
                ListenableFuture futureResponse = this.client.getBulkState(envelope);
                DaprProtos.GetBulkStateResponse response = null;
                try {
                    response = (DaprProtos.GetBulkStateResponse)futureResponse.get();
                }
                catch (NullPointerException npe) {
                    return null;
                }
                return response.getItemsList().stream().map(b -> {
                    try {
                        return this.buildStateKeyValue((DaprProtos.BulkStateItem)b, type);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.toList());
            })).map(s -> new Response<List>(context, (List)s));
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    private <T> State<T> buildStateKeyValue(DaprProtos.BulkStateItem item, TypeRef<T> type) throws IOException {
        String key = item.getKey();
        String error = item.getError();
        if (!Strings.isNullOrEmpty((String)error)) {
            return new State(key, error);
        }
        ByteString payload = item.getData();
        byte[] data = payload == null ? null : payload.toByteArray();
        T value = this.stateSerializer.deserialize(data, type);
        String etag = item.getEtag();
        return new State<T>(value, key, etag);
    }

    private <T> State<T> buildStateKeyValue(DaprProtos.GetStateResponse response, String requestedKey, StateOptions stateOptions, TypeRef<T> type) throws IOException {
        ByteString payload = response.getData();
        byte[] data = payload == null ? null : payload.toByteArray();
        T value = this.stateSerializer.deserialize(data, type);
        String etag = response.getEtag();
        String key = requestedKey;
        return new State<T>(value, key, etag, stateOptions);
    }

    @Override
    public Mono<Response<Void>> executeTransaction(ExecuteStateTransactionRequest request) {
        try {
            String stateStoreName = request.getStateStoreName();
            List<TransactionalStateOperation<?>> operations = request.getOperations();
            Map<String, String> metadata = request.getMetadata();
            Context context = request.getContext();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            DaprProtos.ExecuteStateTransactionRequest.Builder builder = DaprProtos.ExecuteStateTransactionRequest.newBuilder();
            builder.setStoreName(stateStoreName);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            for (TransactionalStateOperation<?> operation : operations) {
                DaprProtos.TransactionalStateOperation.Builder operationBuilder = DaprProtos.TransactionalStateOperation.newBuilder();
                operationBuilder.setOperationType(operation.getOperation().toString().toLowerCase());
                operationBuilder.setRequest(this.buildStateRequest(operation.getRequest()).build());
                builder.addOperations(operationBuilder.build());
            }
            DaprProtos.ExecuteStateTransactionRequest req = builder.build();
            return Mono.fromCallable(DaprClientGrpc.wrap(context, () -> this.client.executeStateTransaction(req))).flatMap(f -> {
                try {
                    f.get();
                }
                catch (Exception e) {
                    return Mono.error((Throwable)e);
                }
                return Mono.empty();
            }).thenReturn(new Response<Object>(context, null));
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<Response<Void>> saveStates(SaveStateRequest request) {
        try {
            String stateStoreName = request.getStateStoreName();
            List<State<?>> states = request.getStates();
            Context context = request.getContext();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            DaprProtos.SaveStateRequest.Builder builder = DaprProtos.SaveStateRequest.newBuilder();
            builder.setStoreName(stateStoreName);
            for (State<?> state : states) {
                builder.addStates(this.buildStateRequest(state).build());
            }
            DaprProtos.SaveStateRequest req = builder.build();
            return Mono.fromCallable(DaprClientGrpc.wrap(context, () -> this.client.saveState(req))).flatMap(f -> {
                try {
                    f.get();
                }
                catch (Exception ex) {
                    return Mono.error((Throwable)ex);
                }
                return Mono.empty();
            }).thenReturn(new Response<Object>(context, null));
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    private <T> CommonProtos.StateItem.Builder buildStateRequest(State<T> state) throws IOException {
        byte[] bytes = this.stateSerializer.serialize(state.getValue());
        CommonProtos.StateItem.Builder stateBuilder = CommonProtos.StateItem.newBuilder();
        if (state.getEtag() != null) {
            stateBuilder.setEtag(state.getEtag());
        }
        if (bytes != null) {
            stateBuilder.setValue(ByteString.copyFrom((byte[])bytes));
        }
        stateBuilder.setKey(state.getKey());
        CommonProtos.StateOptions.Builder optionBuilder = null;
        if (state.getOptions() != null) {
            StateOptions options = state.getOptions();
            optionBuilder = CommonProtos.StateOptions.newBuilder();
            if (options.getConcurrency() != null) {
                optionBuilder.setConcurrency(this.getGrpcStateConcurrency(options));
            }
            if (options.getConsistency() != null) {
                optionBuilder.setConsistency(this.getGrpcStateConsistency(options));
            }
        }
        if (optionBuilder != null) {
            stateBuilder.setOptions(optionBuilder.build());
        }
        return stateBuilder;
    }

    @Override
    public Mono<Response<Void>> deleteState(DeleteStateRequest request) {
        try {
            String stateStoreName = request.getStateStoreName();
            String key = request.getKey();
            StateOptions options = request.getStateOptions();
            String etag = request.getEtag();
            Context context = request.getContext();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            CommonProtos.StateOptions.Builder optionBuilder = null;
            if (options != null) {
                optionBuilder = CommonProtos.StateOptions.newBuilder();
                if (options.getConcurrency() != null) {
                    optionBuilder.setConcurrency(this.getGrpcStateConcurrency(options));
                }
                if (options.getConsistency() != null) {
                    optionBuilder.setConsistency(this.getGrpcStateConsistency(options));
                }
            }
            DaprProtos.DeleteStateRequest.Builder builder = DaprProtos.DeleteStateRequest.newBuilder().setStoreName(stateStoreName).setKey(key).putAllMetadata(request.getMetadata());
            if (etag != null) {
                builder.setEtag(etag);
            }
            if (optionBuilder != null) {
                builder.setOptions(optionBuilder.build());
            }
            DaprProtos.DeleteStateRequest req = builder.build();
            return Mono.fromCallable(DaprClientGrpc.wrap(context, () -> this.client.deleteState(req))).flatMap(f -> {
                try {
                    f.get();
                }
                catch (Exception ex) {
                    return Mono.error((Throwable)ex);
                }
                return Mono.empty();
            }).thenReturn(new Response<Object>(context, null));
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    private <K> DaprProtos.InvokeServiceRequest buildInvokeServiceRequest(HttpExtension httpExtension, String appId, String method, K request) throws IOException {
        if (httpExtension == null) {
            throw new IllegalArgumentException("HttpExtension cannot be null. Use HttpExtension.NONE instead.");
        }
        CommonProtos.InvokeRequest.Builder requestBuilder = CommonProtos.InvokeRequest.newBuilder();
        requestBuilder.setMethod(method);
        if (request != null) {
            byte[] byteRequest = this.objectSerializer.serialize(request);
            Any data = Any.newBuilder().setValue(ByteString.copyFrom((byte[])byteRequest)).build();
            requestBuilder.setData(data);
        } else {
            requestBuilder.setData(Any.newBuilder().build());
        }
        CommonProtos.HTTPExtension.Builder httpExtensionBuilder = CommonProtos.HTTPExtension.newBuilder();
        httpExtensionBuilder.setVerb(CommonProtos.HTTPExtension.Verb.valueOf((String)httpExtension.getMethod().toString())).putAllQuerystring(httpExtension.getQueryString());
        requestBuilder.setHttpExtension(httpExtensionBuilder.build());
        requestBuilder.setContentType(this.objectSerializer.getContentType());
        DaprProtos.InvokeServiceRequest.Builder envelopeBuilder = DaprProtos.InvokeServiceRequest.newBuilder().setId(appId).setMessage(requestBuilder.build());
        return envelopeBuilder.build();
    }

    @Override
    public Mono<Response<Map<String, String>>> getSecret(GetSecretRequest request) {
        String secretStoreName = request.getSecretStoreName();
        String key = request.getKey();
        Map<String, String> metadata = request.getMetadata();
        Context context = request.getContext();
        try {
            if (secretStoreName == null || secretStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("Secret store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Secret key cannot be null or empty.");
            }
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        DaprProtos.GetSecretRequest.Builder requestBuilder = DaprProtos.GetSecretRequest.newBuilder().setStoreName(secretStoreName).setKey(key);
        if (metadata != null) {
            requestBuilder.putAllMetadata(metadata);
        }
        return Mono.fromCallable(DaprClientGrpc.wrap(context, () -> {
            DaprProtos.GetSecretRequest req = requestBuilder.build();
            ListenableFuture future = this.client.getSecret(req);
            return (DaprProtos.GetSecretResponse)future.get();
        })).map(future -> new Response<Map>(context, future.getDataMap()));
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    private static DaprGrpc.DaprFutureStub populateWithInterceptors(DaprGrpc.DaprFutureStub client) {
        ClientInterceptor interceptor = new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
                ClientCall clientCall = channel.newCall(methodDescriptor, callOptions);
                return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(clientCall){

                    public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                        String daprApiToken;
                        Context context = Context.current();
                        SpanContext opencensusSpanContext = DaprClientGrpc.extractOpenCensusSpanContext(context);
                        if (opencensusSpanContext != null) {
                            byte[] grpcTraceBin = OPENCENSUS_BINARY_FORMAT.toByteArray(opencensusSpanContext);
                            headers.put(Metadata.Key.of((String)"grpc-trace-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER), (Object)grpcTraceBin);
                        }
                        if ((daprApiToken = Properties.API_TOKEN.get()) != null) {
                            headers.put(Metadata.Key.of((String)"dapr-api-token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)daprApiToken);
                        }
                        super.start(responseListener, headers);
                    }
                };
            }
        };
        return (DaprGrpc.DaprFutureStub)client.withInterceptors(new ClientInterceptor[]{interceptor});
    }

    private static SpanContext extractOpenCensusSpanContext(Context openTelemetryContext) {
        HashMap map = new HashMap();
        OpenTelemetry.getPropagators().getHttpTextFormat().inject(openTelemetryContext, map, (HttpTextFormat.Setter)new HttpTextFormat.Setter<Map<String, String>>(){

            public void set(Map<String, String> map, String key, String value) {
                if (map != null) {
                    map.put(key, value);
                }
            }
        });
        if (!map.containsKey("traceparent")) {
            return null;
        }
        try {
            return new TraceContextFormat().extract(map, (TextFormat.Getter)new TextFormat.Getter<Map<String, String>>(){

                @Nullable
                public String get(Map<String, String> map, String key) {
                    return map.get(key);
                }
            });
        }
        catch (SpanContextParseException e) {
            throw new RuntimeException(e);
        }
    }

    private static <V> Callable<V> wrap(Context context, Callable<V> callable) {
        if (context == null) {
            return callable;
        }
        return context.wrap(callable);
    }
}

