/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import io.dapr.client.DaprClient;
import io.dapr.client.DaprClientGrpc;
import io.dapr.client.DaprClientHttp;
import io.dapr.client.DaprHttp;
import io.dapr.config.Properties;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.serializer.DefaultObjectSerializer;
import io.dapr.v1.DaprGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.Closeable;
import okhttp3.OkHttpClient;

public class DaprClientBuilder {
    private final boolean useGrpc;
    private DaprObjectSerializer objectSerializer = new DefaultObjectSerializer();
    private DaprObjectSerializer stateSerializer = new DefaultObjectSerializer();

    public DaprClientBuilder() {
        this.useGrpc = Properties.USE_GRPC.get();
    }

    public DaprClientBuilder withObjectSerializer(DaprObjectSerializer objectSerializer) {
        if (objectSerializer == null) {
            throw new IllegalArgumentException("Object serializer is required");
        }
        if (objectSerializer.getContentType() == null || objectSerializer.getContentType().isEmpty()) {
            throw new IllegalArgumentException("Content Type should not be null or empty");
        }
        this.objectSerializer = objectSerializer;
        return this;
    }

    public DaprClientBuilder withStateSerializer(DaprObjectSerializer stateSerializer) {
        if (stateSerializer == null) {
            throw new IllegalArgumentException("State serializer is required");
        }
        this.stateSerializer = stateSerializer;
        return this;
    }

    public DaprClient build() {
        if (this.useGrpc) {
            return this.buildDaprClientGrpc();
        }
        return this.buildDaprClientHttp();
    }

    private DaprClient buildDaprClientGrpc() {
        int port = Properties.GRPC_PORT.get();
        if (port <= 0) {
            throw new IllegalStateException("Invalid port.");
        }
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)Properties.SIDECAR_IP.get(), (int)port).usePlaintext().build();
        Closeable closeableChannel = () -> {
            if (channel != null && !channel.isShutdown()) {
                channel.shutdown();
            }
        };
        DaprGrpc.DaprFutureStub stub = DaprGrpc.newFutureStub((Channel)channel);
        return new DaprClientGrpc(closeableChannel, stub, this.objectSerializer, this.stateSerializer);
    }

    private DaprClient buildDaprClientHttp() {
        int port = Properties.HTTP_PORT.get();
        if (port <= 0) {
            throw new IllegalStateException("Invalid port.");
        }
        OkHttpClient okHttpClient = new OkHttpClient.Builder().build();
        DaprHttp daprHttp = new DaprHttp(Properties.SIDECAR_IP.get(), port, okHttpClient);
        return new DaprClientHttp(daprHttp, this.objectSerializer, this.stateSerializer);
    }
}

