/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.utils;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.function.Supplier;

public class Properties {
    private static final Integer DEFAULT_HTTP_PORT = 3500;
    private static final Integer DEFAULT_GRPC_PORT = 50051;
    private static final Boolean DEFAULT_GRPC_ENABLED = true;
    private static final String DEFAULT_STRING_CHARSET = StandardCharsets.UTF_8.name();
    public static final Supplier<Integer> HTTP_PORT = () -> Properties.getIntOrDefault("dapr.http.port", "DAPR_HTTP_PORT", DEFAULT_HTTP_PORT);
    public static final Supplier<Integer> GRPC_PORT = () -> Properties.getIntOrDefault("dapr.grpc.port", "DAPR_GRPC_PORT", DEFAULT_GRPC_PORT);
    public static final Supplier<Boolean> USE_GRPC = () -> Properties.getBooleanOrDefault("dapr.grpc.enabled", "DAPR_GRPC_ENABLED", DEFAULT_GRPC_ENABLED);
    public static final Supplier<Charset> STRING_CHARSET = () -> Charset.forName(Properties.getStringOrDefault("dapr.string.charset", "DAPR_STRING_CHARSET", DEFAULT_STRING_CHARSET));

    public static Integer getIntOrDefault(String propName, String envName, Integer defaultValue) {
        return Properties.getValueOrDefault(propName, envName, defaultValue, s -> Integer.valueOf(s));
    }

    public static Boolean getBooleanOrDefault(String propName, String envName, Boolean defaultValue) {
        return Properties.getValueOrDefault(propName, envName, defaultValue, s -> Boolean.valueOf(s));
    }

    public static String getStringOrDefault(String propName, String envName, String defaultValue) {
        return Properties.getValueOrDefault(propName, envName, defaultValue, s -> s);
    }

    private static <T> T getValueOrDefault(String propName, String envName, T defaultValue, Function<String, T> parser) {
        String envValue;
        String propValue = System.getProperty(propName);
        if (propValue != null && !propValue.trim().isEmpty()) {
            try {
                return parser.apply(propValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((envValue = System.getenv(envName)) == null || envValue.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            return parser.apply(envValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }
}

