/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.dapr.utils.DurationUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class StateOptions {
    private final Consistency consistency;
    private final Concurrency concurrency;
    private final RetryPolicy retryPolicy;

    public StateOptions(Consistency consistency, Concurrency concurrency, RetryPolicy retryPolicy) {
        this.consistency = consistency;
        this.concurrency = concurrency;
        this.retryPolicy = retryPolicy;
    }

    public Concurrency getConcurrency() {
        return this.concurrency;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @JsonIgnore
    public Map<String, String> getStateOptionsAsMap() {
        HashMap<String, String> mapOptions = null;
        if (this != null) {
            mapOptions = new HashMap<String, String>();
            if (this.getConsistency() != null) {
                mapOptions.put("consistency", this.getConsistency().getValue());
            }
            if (this.getConcurrency() != null) {
                mapOptions.put("concurrency", this.getConcurrency().getValue());
            }
            if (this.getRetryPolicy() != null) {
                if (this.getRetryPolicy().getInterval() != null) {
                    mapOptions.put("retryInterval", String.valueOf(this.getRetryPolicy().getInterval().toMillis()));
                }
                if (this.getRetryPolicy().getThreshold() != null) {
                    mapOptions.put("retryThreshold", this.getRetryPolicy().getThreshold().toString());
                }
                if (this.getRetryPolicy().getPattern() != null) {
                    mapOptions.put("retryPattern", this.getRetryPolicy().getPattern().getValue());
                }
            }
        }
        return Collections.unmodifiableMap(Optional.ofNullable(mapOptions).orElse(Collections.EMPTY_MAP));
    }

    public static enum Consistency {
        EVENTUAL("eventual"),
        STRONG("strong");

        private final String value;

        private Consistency(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Consistency fromValue(String value) {
            return Consistency.valueOf(value);
        }
    }

    public static enum Concurrency {
        FIRST_WRITE("first-write"),
        LAST_WRITE("last-write");

        private final String value;

        private Concurrency(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Concurrency fromValue(String value) {
            return Concurrency.valueOf(value);
        }
    }

    public static class RetryPolicy {
        @JsonSerialize(using=StateOptionDurationSerializer.class)
        @JsonDeserialize(using=StateOptionDurationDeserializer.class)
        private final Duration interval;
        private final Integer threshold;
        private final Pattern pattern;

        public RetryPolicy(Duration interval, Integer threshold, Pattern pattern) {
            this.interval = interval;
            this.threshold = threshold;
            this.pattern = pattern;
        }

        public Duration getInterval() {
            return this.interval;
        }

        public Integer getThreshold() {
            return this.threshold;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public static enum Pattern {
            LINEAR("linear"),
            EXPONENTIAL("exponential");

            private String value;

            private Pattern(String value) {
                this.value = value;
            }

            @JsonValue
            public String getValue() {
                return this.value;
            }

            @JsonCreator
            public static Pattern fromValue(String value) {
                return Pattern.valueOf(value);
            }
        }
    }

    public static class StateOptionDurationDeserializer
    extends StdDeserializer<Duration> {
        public StateOptionDurationDeserializer(Class<?> vc) {
            super(vc);
        }

        public Duration deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String durationStr = (String)jsonParser.readValueAs(String.class);
            Duration duration = null;
            if (durationStr != null && !durationStr.trim().isEmpty()) {
                try {
                    duration = DurationUtils.convertDurationFromDaprFormat(durationStr);
                }
                catch (Exception ex) {
                    throw InvalidFormatException.from((JsonParser)jsonParser, (String)"Unable to parse duration.", (Throwable)ex);
                }
            }
            return duration;
        }
    }

    public static class StateOptionDurationSerializer
    extends StdSerializer<Duration> {
        public StateOptionDurationSerializer() {
            super(Duration.class);
        }

        public StateOptionDurationSerializer(Class<Duration> t) {
            super(t);
        }

        public void serialize(Duration duration, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNumber(duration.toMillis());
        }
    }
}

