/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;

public final class CloudEvent {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final String id;
    private final String source;
    private final String type;
    private final String specversion;
    private final String datacontenttype;
    private final String data;

    public CloudEvent(String id, String source, String type, String specversion, String datacontenttype, String data) {
        this.id = id;
        this.source = source;
        this.type = type;
        this.specversion = specversion;
        this.datacontenttype = datacontenttype;
        this.data = data;
    }

    public String getId() {
        return this.id;
    }

    public String getSource() {
        return this.source;
    }

    public String getType() {
        return this.type;
    }

    public String getSpecversion() {
        return this.specversion;
    }

    public String getDatacontenttype() {
        return this.datacontenttype;
    }

    public String getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudEvent that = (CloudEvent)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && Objects.equals(this.type, that.type) && Objects.equals(this.specversion, that.specversion) && Objects.equals(this.datacontenttype, that.datacontenttype) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source, this.type, this.specversion, this.datacontenttype, this.data);
    }

    public static CloudEvent deserialize(byte[] payload) throws IOException {
        if (payload == null) {
            return null;
        }
        JsonNode node = OBJECT_MAPPER.readTree(payload);
        if (node == null) {
            return null;
        }
        String id = null;
        if (node.has("id") && !node.get("id").isNull()) {
            id = node.get("id").asText();
        }
        String source = null;
        if (node.has("source") && !node.get("source").isNull()) {
            source = node.get("source").asText();
        }
        String type = null;
        if (node.has("type") && !node.get("type").isNull()) {
            type = node.get("type").asText();
        }
        String specversion = null;
        if (node.has("specversion") && !node.get("specversion").isNull()) {
            specversion = node.get("specversion").asText();
        }
        String datacontenttype = null;
        if (node.has("datacontenttype") && !node.get("datacontenttype").isNull()) {
            datacontenttype = node.get("datacontenttype").asText();
        }
        String data = null;
        if (node.has("data") && !node.get("data").isNull()) {
            JsonNode dataNode = node.get("data");
            data = dataNode.isTextual() ? dataNode.textValue() : node.get("data").toString();
        }
        return new CloudEvent(id, source, type, specversion, datacontenttype, data);
    }
}

