/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dapr.client.domain.CloudEvent;
import java.io.IOException;

public class ObjectSerializer {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    protected ObjectSerializer() {
    }

    public byte[] serialize(Object state) throws IOException {
        if (state == null) {
            return null;
        }
        if (state.getClass() == Void.class) {
            return null;
        }
        if (state instanceof byte[]) {
            return (byte[])state;
        }
        return OBJECT_MAPPER.writeValueAsBytes(state);
    }

    public <T> T deserialize(byte[] content, Class<T> clazz) throws IOException {
        if (clazz == null || clazz == Void.class) {
            return null;
        }
        if (clazz.isPrimitive()) {
            return ObjectSerializer.deserializePrimitives(content, clazz);
        }
        if (content == null) {
            return null;
        }
        if (clazz == byte[].class) {
            return (T)content;
        }
        if (content.length == 0) {
            return null;
        }
        if (clazz == CloudEvent.class) {
            return (T)CloudEvent.deserialize(content);
        }
        return (T)OBJECT_MAPPER.readValue(content, clazz);
    }

    private static <T> T deserializePrimitives(byte[] content, Class<T> clazz) throws IOException {
        if (content == null || content.length == 0) {
            if (Boolean.TYPE == clazz) {
                return (T)Boolean.FALSE;
            }
            if (Byte.TYPE == clazz) {
                return (T)Byte.valueOf((byte)0);
            }
            if (Short.TYPE == clazz) {
                return (T)Short.valueOf((short)0);
            }
            if (Integer.TYPE == clazz) {
                return (T)Integer.valueOf(0);
            }
            if (Long.TYPE == clazz) {
                return (T)Long.valueOf(0L);
            }
            if (Float.TYPE == clazz) {
                return (T)Float.valueOf(0.0f);
            }
            if (Double.TYPE == clazz) {
                return (T)Double.valueOf(0.0);
            }
            if (Character.TYPE == clazz) {
                return (T)Character.valueOf('\u0000');
            }
            return null;
        }
        return (T)OBJECT_MAPPER.readValue(content, clazz);
    }
}

