/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dapr.exceptions.DaprError;
import io.dapr.exceptions.DaprException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import reactor.core.publisher.Mono;

public class DaprHttp {
    private static final MediaType MEDIA_TYPE_APPLICATION_JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final RequestBody REQUEST_BODY_EMPTY_JSON = RequestBody.Companion.create("", MEDIA_TYPE_APPLICATION_JSON);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final int port;
    private final OkHttpClient httpClient;

    DaprHttp(int port, OkHttpClient httpClient) {
        this.port = port;
        this.httpClient = httpClient;
    }

    public Mono<Response> invokeApi(String method, String urlString, Map<String, String> urlParameters, Map<String, String> headers) {
        return this.invokeApi(method, urlString, urlParameters, (byte[])null, headers);
    }

    public Mono<Response> invokeApi(String method, String urlString, Map<String, String> urlParameters, String content, Map<String, String> headers) {
        return this.invokeApi(method, urlString, urlParameters, content == null ? EMPTY_BYTES : content.getBytes(StandardCharsets.UTF_8), headers);
    }

    public Mono<Response> invokeApi(String method, String urlString, Map<String, String> urlParameters, byte[] content, Map<String, String> headers) {
        return Mono.fromCallable(() -> {
            MediaType mediaType;
            String requestId = UUID.randomUUID().toString();
            String contentType = headers != null ? (String)headers.get("content-type") : null;
            MediaType mediaType2 = mediaType = contentType == null ? MEDIA_TYPE_APPLICATION_JSON : MediaType.get((String)contentType);
            RequestBody body = content == null ? (mediaType.equals((Object)MEDIA_TYPE_APPLICATION_JSON) ? REQUEST_BODY_EMPTY_JSON : RequestBody.Companion.create(new byte[0], mediaType)) : RequestBody.Companion.create(content, mediaType);
            HttpUrl.Builder urlBuilder = new HttpUrl.Builder();
            urlBuilder.scheme("http").host("127.0.0.1").port(this.port).addPathSegments(urlString);
            Optional.ofNullable(urlParameters).orElse(Collections.emptyMap()).entrySet().stream().forEach(urlParameter -> urlBuilder.addQueryParameter((String)urlParameter.getKey(), (String)urlParameter.getValue()));
            Request.Builder requestBuilder = new Request.Builder().url(urlBuilder.build()).addHeader("X-DaprRequestId", requestId);
            if (HttpMethods.GET.name().equals(method)) {
                requestBuilder.get();
            } else if (HttpMethods.DELETE.name().equals(method)) {
                requestBuilder.delete();
            } else {
                requestBuilder.method(method, body);
            }
            if (headers != null) {
                Optional.ofNullable(headers.entrySet()).orElse(Collections.emptySet()).stream().forEach(header -> requestBuilder.addHeader((String)header.getKey(), (String)header.getValue()));
            }
            Request request = requestBuilder.build();
            try (okhttp3.Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    DaprError error = DaprHttp.parseDaprError(response.body().bytes());
                    if (error != null && error.getErrorCode() != null && error.getMessage() != null) {
                        throw new DaprException(error);
                    }
                    throw new IllegalStateException("Unknown Dapr error. HTTP status code: " + response.code());
                }
                HashMap<String, String> mapHeaders = new HashMap<String, String>();
                byte[] result = response.body().bytes();
                response.headers().forEach(pair -> mapHeaders.put((String)pair.getFirst(), (String)pair.getSecond()));
                Response response2 = new Response(result, mapHeaders, response.code());
                return response2;
            }
        });
    }

    private static DaprError parseDaprError(byte[] json) throws IOException {
        if (json == null || json.length == 0) {
            return null;
        }
        return (DaprError)OBJECT_MAPPER.readValue(json, DaprError.class);
    }

    public static enum HttpMethods {
        GET,
        PUT,
        POST,
        DELETE;

    }

    public static class Response {
        private byte[] body;
        private Map<String, String> headers;
        private int statusCode;

        public Response(byte[] body, Map<String, String> headers, int statusCode) {
            this.body = body == null ? EMPTY_BYTES : Arrays.copyOf(body, body.length);
            this.headers = headers;
            this.statusCode = statusCode;
        }

        public byte[] getBody() {
            return Arrays.copyOf(this.body, this.body.length);
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

