/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import io.dapr.client.DaprClient;
import io.dapr.client.DaprHttp;
import io.dapr.client.ObjectSerializer;
import io.dapr.client.domain.State;
import io.dapr.client.domain.StateOptions;
import io.dapr.client.domain.Verb;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.serializer.DefaultObjectSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import reactor.core.publisher.Mono;

public class DaprClientHttp
implements DaprClient {
    private static final ObjectSerializer INTERNAL_SERIALIZER = new ObjectSerializer();
    private final DaprHttp client;
    private final DaprObjectSerializer objectSerializer;
    private final DaprObjectSerializer stateSerializer;
    private final boolean isObjectSerializerDefault;
    private final boolean isStateSerializerDefault;

    DaprClientHttp(DaprHttp client, DaprObjectSerializer objectSerializer, DaprObjectSerializer stateSerializer) {
        this.client = client;
        this.objectSerializer = objectSerializer;
        this.stateSerializer = stateSerializer;
        this.isObjectSerializerDefault = objectSerializer.getClass() == DefaultObjectSerializer.class;
        this.isStateSerializerDefault = stateSerializer.getClass() == DefaultObjectSerializer.class;
    }

    DaprClientHttp(DaprHttp client) {
        this(client, new DefaultObjectSerializer(), new DefaultObjectSerializer());
    }

    @Override
    public Mono<Void> publishEvent(String topic, Object event) {
        return this.publishEvent(topic, event, null);
    }

    @Override
    public Mono<Void> publishEvent(String topic, Object event, Map<String, String> metadata) {
        try {
            if (topic == null || topic.trim().isEmpty()) {
                throw new IllegalArgumentException("Topic name cannot be null or empty.");
            }
            byte[] serializedEvent = this.objectSerializer.serialize(event);
            StringBuilder url = new StringBuilder("v1.0/publish").append("/").append(topic);
            return this.client.invokeApi(DaprHttp.HttpMethods.POST.name(), url.toString(), null, serializedEvent, metadata).then();
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public <T> Mono<T> invokeService(Verb verb, String appId, String method, Object request, Map<String, String> metadata, Class<T> clazz) {
        try {
            if (verb == null) {
                throw new IllegalArgumentException("Verb cannot be null.");
            }
            String httMethod = verb.toString();
            if (appId == null || appId.trim().isEmpty()) {
                throw new IllegalArgumentException("App Id cannot be null or empty.");
            }
            if (method == null || method.trim().isEmpty()) {
                throw new IllegalArgumentException("Method name cannot be null or empty.");
            }
            String path = String.format("%s/%s/method/%s", "v1.0/invoke", appId, method);
            byte[] serializedRequestBody = this.objectSerializer.serialize(request);
            Mono<DaprHttp.Response> response = this.client.invokeApi(httMethod, path, metadata, serializedRequestBody, null);
            return response.flatMap(r -> {
                try {
                    Object object = this.objectSerializer.deserialize(r.getBody(), clazz);
                    if (object == null) {
                        return Mono.empty();
                    }
                    return Mono.just(object);
                }
                catch (Exception ex) {
                    return Mono.error((Throwable)ex);
                }
            });
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public <T> Mono<T> invokeService(Verb verb, String appId, String method, Map<String, String> metadata, Class<T> clazz) {
        return this.invokeService(verb, appId, method, null, metadata, clazz);
    }

    @Override
    public <T> Mono<T> invokeService(Verb verb, String appId, String method, Object request, Class<T> clazz) {
        return this.invokeService(verb, appId, method, request, null, clazz);
    }

    @Override
    public Mono<Void> invokeService(Verb verb, String appId, String method, Object request) {
        return this.invokeService(verb, appId, method, request, null, byte[].class).then();
    }

    @Override
    public Mono<Void> invokeService(Verb verb, String appId, String method, Object request, Map<String, String> metadata) {
        return this.invokeService(verb, appId, method, request, metadata, byte[].class).then();
    }

    @Override
    public Mono<Void> invokeService(Verb verb, String appId, String method, Map<String, String> metadata) {
        return this.invokeService(verb, appId, method, null, metadata, byte[].class).then();
    }

    @Override
    public Mono<byte[]> invokeService(Verb verb, String appId, String method, byte[] request, Map<String, String> metadata) {
        return this.invokeService(verb, appId, method, request, metadata, byte[].class);
    }

    @Override
    public Mono<Void> invokeBinding(String name, Object request) {
        return this.invokeBinding(name, request, null);
    }

    @Override
    public Mono<Void> invokeBinding(String name, Object request, Map<String, String> metadata) {
        try {
            if (name == null || name.trim().isEmpty()) {
                throw new IllegalArgumentException("Binding name cannot be null or empty.");
            }
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            if (metadata != null) {
                jsonMap.put("metadata", metadata);
            }
            if (request != null) {
                if (this.isObjectSerializerDefault) {
                    jsonMap.put("data", request);
                } else {
                    jsonMap.put("data", this.objectSerializer.serialize(request));
                }
            }
            StringBuilder url = new StringBuilder("v1.0/bindings").append("/").append(name);
            return this.client.invokeApi(DaprHttp.HttpMethods.POST.name(), url.toString(), null, INTERNAL_SERIALIZER.serialize(jsonMap), null).then();
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public <T> Mono<State<T>> getState(String stateStoreName, State<T> state, Class<T> clazz) {
        return this.getState(stateStoreName, state.getKey(), state.getEtag(), state.getOptions(), clazz);
    }

    @Override
    public <T> Mono<State<T>> getState(String stateStoreName, String key, Class<T> clazz) {
        return this.getState(stateStoreName, key, null, null, clazz);
    }

    @Override
    public <T> Mono<State<T>> getState(String stateStoreName, String key, String etag, StateOptions options, Class<T> clazz) {
        try {
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            if (etag != null && !etag.trim().isEmpty()) {
                headers.put("If-Match", etag);
            }
            StringBuilder url = new StringBuilder("v1.0/state").append("/").append(stateStoreName).append("/").append(key);
            Map urlParameters = Optional.ofNullable(options).map(o -> o.getStateOptionsAsMap()).orElse(new HashMap());
            return this.client.invokeApi(DaprHttp.HttpMethods.GET.name(), url.toString(), urlParameters, headers).flatMap(s -> {
                try {
                    return Mono.just(this.buildStateKeyValue((DaprHttp.Response)s, key, options, clazz));
                }
                catch (Exception ex) {
                    return Mono.error((Throwable)ex);
                }
            });
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public Mono<Void> saveStates(String stateStoreName, List<State<?>> states) {
        try {
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (states == null || states.isEmpty()) {
                return Mono.empty();
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            String etag = states.stream().filter(state -> null != state.getEtag() && !state.getEtag().trim().isEmpty()).findFirst().orElse(new State<Object>(null, null, null, null)).getEtag();
            if (etag != null && !etag.trim().isEmpty()) {
                headers.put("If-Match", etag);
            }
            String url = "v1.0/state/" + stateStoreName;
            ArrayList internalStateObjects = new ArrayList(states.size());
            for (State<?> state2 : states) {
                if (state2 == null) continue;
                if (this.isStateSerializerDefault) {
                    internalStateObjects.add(state2);
                    continue;
                }
                byte[] data = this.stateSerializer.serialize(state2.getValue());
                internalStateObjects.add(new State<byte[]>(data, state2.getKey(), state2.getEtag(), state2.getOptions()));
            }
            byte[] serializedStateBody = INTERNAL_SERIALIZER.serialize(internalStateObjects);
            return this.client.invokeApi(DaprHttp.HttpMethods.POST.name(), url, null, serializedStateBody, headers).then();
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public Mono<Void> saveState(String stateStoreName, String key, Object value) {
        return this.saveState(stateStoreName, key, null, value, null);
    }

    @Override
    public Mono<Void> saveState(String stateStoreName, String key, String etag, Object value, StateOptions options) {
        return Mono.fromSupplier(() -> new State<Object>(value, key, etag, options)).flatMap(state -> this.saveStates(stateStoreName, Arrays.asList(state)));
    }

    @Override
    public Mono<Void> deleteState(String stateStoreName, String key) {
        return this.deleteState(stateStoreName, key, null, null);
    }

    @Override
    public Mono<Void> deleteState(String stateStoreName, String key, String etag, StateOptions options) {
        try {
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            if (etag != null && !etag.trim().isEmpty()) {
                headers.put("If-Match", etag);
            }
            String url = "v1.0/state/" + stateStoreName + "/" + key;
            Map urlParameters = Optional.ofNullable(options).map(stateOptions -> stateOptions.getStateOptionsAsMap()).orElse(new HashMap());
            return this.client.invokeApi(DaprHttp.HttpMethods.DELETE.name(), url, urlParameters, headers).then();
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    private <T> State<T> buildStateKeyValue(DaprHttp.Response response, String requestedKey, StateOptions stateOptions, Class<T> clazz) throws IOException {
        T value = this.stateSerializer.deserialize(response.getBody(), clazz);
        String key = requestedKey;
        String etag = null;
        if (response.getHeaders() != null && response.getHeaders().containsKey("Etag")) {
            etag = response.getHeaders().get("Etag");
        }
        return new State<T>(value, key, etag, stateOptions);
    }

    @Override
    public Mono<Map<String, String>> getSecret(String secretStoreName, String secretName, Map<String, String> metadata) {
        try {
            if (secretStoreName == null || secretStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("Secret store name cannot be null or empty.");
            }
            if (secretName == null || secretName.trim().isEmpty()) {
                throw new IllegalArgumentException("Secret name cannot be null or empty.");
            }
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        String url = "v1.0/secrets/" + secretStoreName + "/" + secretName;
        return this.client.invokeApi(DaprHttp.HttpMethods.GET.name(), url, metadata, (String)null, null).flatMap(response -> {
            try {
                Map m = INTERNAL_SERIALIZER.deserialize(response.getBody(), Map.class);
                if (m == null) {
                    return Mono.just((Object)Collections.EMPTY_MAP);
                }
                return Mono.just((Object)m);
            }
            catch (IOException e) {
                return Mono.error((Throwable)e);
            }
        }).map(m -> m);
    }

    @Override
    public Mono<Map<String, String>> getSecret(String secretStoreName, String secretName) {
        return this.getSecret(secretStoreName, secretName, null);
    }
}

