/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain;

import io.dapr.client.domain.PublishEventRequest;
import io.grpc.Context;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PublishEventRequestBuilder {
    private final String pubsubName;
    private final String topic;
    private final Object data;
    private Map<String, String> metadata = new HashMap<String, String>();
    private Context context;

    public PublishEventRequestBuilder(String pubsubName, String topic, Object data) {
        this.pubsubName = pubsubName;
        this.topic = topic;
        this.data = data;
    }

    public PublishEventRequestBuilder withMetadata(Map<String, String> metadata) {
        this.metadata = metadata == null ? null : Collections.unmodifiableMap(metadata);
        return this;
    }

    public PublishEventRequestBuilder withContext(Context context) {
        this.context = context;
        return this;
    }

    public PublishEventRequest build() {
        PublishEventRequest request = new PublishEventRequest();
        request.setPubsubName(this.pubsubName);
        request.setTopic(this.topic);
        request.setData(this.data);
        request.setMetadata(this.metadata);
        request.setContext(this.context);
        return request;
    }
}

