/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain;

import io.dapr.client.DaprHttp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class HttpExtension {
    public static final HttpExtension NONE = new HttpExtension(DaprHttp.HttpMethods.NONE, new HashMap<String, String>());
    public static final HttpExtension GET = new HttpExtension(DaprHttp.HttpMethods.GET, new HashMap<String, String>());
    public static final HttpExtension PUT = new HttpExtension(DaprHttp.HttpMethods.PUT, new HashMap<String, String>());
    public static final HttpExtension POST = new HttpExtension(DaprHttp.HttpMethods.POST, new HashMap<String, String>());
    public static final HttpExtension DELETE = new HttpExtension(DaprHttp.HttpMethods.DELETE, new HashMap<String, String>());
    public static final HttpExtension HEAD = new HttpExtension(DaprHttp.HttpMethods.HEAD, new HashMap<String, String>());
    public static final HttpExtension CONNECT = new HttpExtension(DaprHttp.HttpMethods.CONNECT, new HashMap<String, String>());
    public static final HttpExtension OPTIONS = new HttpExtension(DaprHttp.HttpMethods.OPTIONS, new HashMap<String, String>());
    public static final HttpExtension TRACE = new HttpExtension(DaprHttp.HttpMethods.TRACE, new HashMap<String, String>());
    private DaprHttp.HttpMethods method;
    private Map<String, String> queryString;

    public HttpExtension(DaprHttp.HttpMethods method, Map<String, String> queryString) {
        if (method == null) {
            throw new IllegalArgumentException("HttpExtension method cannot be null");
        }
        if (queryString == null) {
            throw new IllegalArgumentException("HttpExtension queryString map cannot be null");
        }
        this.method = method;
        this.queryString = Collections.unmodifiableMap(queryString);
    }

    public DaprHttp.HttpMethods getMethod() {
        return this.method;
    }

    public Map<String, String> getQueryString() {
        return this.queryString;
    }
}

