/*
 * Decompiled with CFR 0.152.
 */
package io.d11.aerospike.client.impl;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.Bin;
import com.aerospike.client.Host;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.async.EventLoops;
import com.aerospike.client.cluster.ClusterStats;
import com.aerospike.client.listener.BatchListListener;
import com.aerospike.client.listener.DeleteListener;
import com.aerospike.client.listener.ExecuteListener;
import com.aerospike.client.listener.ExistsArrayListener;
import com.aerospike.client.listener.ExistsListener;
import com.aerospike.client.listener.RecordArrayListener;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.PartitionFilter;
import com.aerospike.client.query.Statement;
import io.d11.aerospike.client.AerospikeClient;
import io.d11.aerospike.client.AerospikeConnectOptions;
import io.d11.aerospike.listeners.BatchListListenerImpl;
import io.d11.aerospike.listeners.DeleteListenerImpl;
import io.d11.aerospike.listeners.ExecuteListenerImpl;
import io.d11.aerospike.listeners.ExistsArrayListenerImpl;
import io.d11.aerospike.listeners.ExistsListenerImpl;
import io.d11.aerospike.listeners.QueryResultListenerImpl;
import io.d11.aerospike.listeners.RecordArrayListenerImpl;
import io.d11.aerospike.listeners.RecordListenerImpl;
import io.d11.aerospike.listeners.WriteListenerImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AerospikeClientImpl
implements AerospikeClient {
    private static final Logger log = LoggerFactory.getLogger(AerospikeClientImpl.class);
    private final VertxInternal vertx;
    private final EventLoops eventLoops;
    private final AerospikeConnectOptions connectOptions;
    private com.aerospike.client.AerospikeClient aerospikeClient;

    public AerospikeClientImpl(Vertx vertx, AerospikeConnectOptions connectOptions) {
        this.vertx = (VertxInternal)vertx;
        this.connectOptions = connectOptions;
        this.aerospikeClient = this.connectClientWithRetry(0);
        this.eventLoops = connectOptions.getClientPolicy().eventLoops;
    }

    @Override
    public com.aerospike.client.AerospikeClient getAerospikeClient() {
        return this.aerospikeClient;
    }

    private <T> void schedule(Handler<Promise<T>> handler, Handler<AsyncResult<T>> resultHandler) {
        this.vertx.getOrCreateContext().executeBlocking(promise -> {
            try {
                handler.handle(promise);
            }
            catch (AerospikeException e) {
                promise.fail((Throwable)e);
            }
        }, result -> resultHandler.handle(result));
    }

    private com.aerospike.client.AerospikeClient connectClientWithRetry(int retryCount) {
        if (this.connectOptions.getMaxConnectRetries() != -1 && retryCount > this.connectOptions.getMaxConnectRetries()) {
            log.error("Exhausted max connection retries after {} attempts", (Object)retryCount);
            throw new AerospikeException(-11, "Cannot connect to Aerospike");
        }
        try {
            Thread.sleep(2L);
            return new com.aerospike.client.AerospikeClient(this.connectOptions.getClientPolicy(), new Host[]{new Host(this.connectOptions.getHost(), this.connectOptions.getPort())});
        }
        catch (Exception e) {
            log.error("Error while connecting to aerospike", (Throwable)e);
            log.info("Retrying to connect to aerospike");
            return this.connectClientWithRetry(retryCount + 1);
        }
    }

    @Override
    public AerospikeClient isConnected(Handler<AsyncResult<Boolean>> handler) {
        this.schedule(promise -> promise.complete((Object)this.aerospikeClient.isConnected()), handler);
        return this;
    }

    @Override
    public AerospikeClient getClusterStats(Handler<AsyncResult<ClusterStats>> handler) {
        this.schedule(promise -> promise.complete((Object)this.aerospikeClient.getClusterStats()), handler);
        return this;
    }

    @Override
    public void close() {
        if (this.aerospikeClient != null) {
            this.aerospikeClient.close();
            this.aerospikeClient = null;
        }
    }

    @Override
    public AerospikeClient put(WritePolicy writePolicy, Key key, Bin[] bins, Handler<AsyncResult<Key>> handler) throws AerospikeException {
        this.aerospikeClient.put(this.eventLoops.next(), (WriteListener)new WriteListenerImpl(this.vertx.getOrCreateContext(), handler), writePolicy, key, bins);
        return this;
    }

    @Override
    public AerospikeClient append(WritePolicy writePolicy, Key key, Bin[] bins, Handler<AsyncResult<Key>> handler) throws AerospikeException {
        this.aerospikeClient.append(this.eventLoops.next(), (WriteListener)new WriteListenerImpl(this.vertx.getOrCreateContext(), handler), writePolicy, key, bins);
        return this;
    }

    @Override
    public AerospikeClient prepend(WritePolicy writePolicy, Key key, Bin[] bins, Handler<AsyncResult<Key>> handler) throws AerospikeException {
        this.aerospikeClient.prepend(this.eventLoops.next(), (WriteListener)new WriteListenerImpl(this.vertx.getOrCreateContext(), handler), writePolicy, key, bins);
        return this;
    }

    @Override
    public AerospikeClient add(WritePolicy writePolicy, Key key, Bin[] bins, Handler<AsyncResult<Key>> handler) throws AerospikeException {
        this.aerospikeClient.add(this.eventLoops.next(), (WriteListener)new WriteListenerImpl(this.vertx.getOrCreateContext(), handler), writePolicy, key, bins);
        return this;
    }

    @Override
    public AerospikeClient delete(WritePolicy writePolicy, Key key, Handler<AsyncResult<Boolean>> handler) throws AerospikeException {
        this.aerospikeClient.delete(this.eventLoops.next(), (DeleteListener)new DeleteListenerImpl(this.vertx.getOrCreateContext(), handler), writePolicy, key);
        return this;
    }

    @Override
    public AerospikeClient touch(WritePolicy writePolicy, Key key, Handler<AsyncResult<Key>> handler) throws AerospikeException {
        this.aerospikeClient.touch(this.eventLoops.next(), (WriteListener)new WriteListenerImpl(this.vertx.getOrCreateContext(), handler), writePolicy, key);
        return this;
    }

    @Override
    public AerospikeClient exists(Policy policy, Key key, Handler<AsyncResult<Boolean>> handler) throws AerospikeException {
        this.aerospikeClient.exists(this.eventLoops.next(), (ExistsListener)new ExistsListenerImpl(this.vertx.getOrCreateContext(), handler), policy, key);
        return this;
    }

    @Override
    public AerospikeClient exists(BatchPolicy batchPolicy, Key[] keys, Handler<AsyncResult<List<Boolean>>> handler) throws AerospikeException {
        this.aerospikeClient.exists(this.eventLoops.next(), (ExistsArrayListener)new ExistsArrayListenerImpl(this.vertx.getOrCreateContext(), handler), batchPolicy, keys);
        return this;
    }

    @Override
    public AerospikeClient get(Policy policy, Key key, Handler<AsyncResult<Record>> handler) throws AerospikeException {
        this.aerospikeClient.get(this.eventLoops.next(), (RecordListener)new RecordListenerImpl(this.vertx.getOrCreateContext(), handler), policy, key);
        return this;
    }

    @Override
    public AerospikeClient get(Policy policy, Key key, String[] binNames, Handler<AsyncResult<Record>> handler) throws AerospikeException {
        this.aerospikeClient.get(this.eventLoops.next(), (RecordListener)new RecordListenerImpl(this.vertx.getOrCreateContext(), handler), policy, key, binNames);
        return this;
    }

    @Override
    public AerospikeClient getHeader(Policy policy, Key key, Handler<AsyncResult<Record>> handler) throws AerospikeException {
        this.aerospikeClient.getHeader(this.eventLoops.next(), (RecordListener)new RecordListenerImpl(this.vertx.getOrCreateContext(), handler), policy, key);
        return this;
    }

    @Override
    public AerospikeClient get(BatchPolicy batchPolicy, List<BatchRead> records, Handler<AsyncResult<List<BatchRead>>> handler) throws AerospikeException {
        this.aerospikeClient.get(this.eventLoops.next(), (BatchListListener)new BatchListListenerImpl(this.vertx.getOrCreateContext(), handler), batchPolicy, records);
        return this;
    }

    @Override
    public AerospikeClient get(BatchPolicy batchPolicy, Key[] keys, Handler<AsyncResult<List<Record>>> handler) throws AerospikeException {
        this.aerospikeClient.get(this.eventLoops.next(), (RecordArrayListener)new RecordArrayListenerImpl(this.vertx.getOrCreateContext(), handler), batchPolicy, keys);
        return this;
    }

    @Override
    public AerospikeClient get(BatchPolicy batchPolicy, Key[] keys, String[] binNames, Handler<AsyncResult<List<Record>>> handler) throws AerospikeException {
        this.aerospikeClient.get(this.eventLoops.next(), (RecordArrayListener)new RecordArrayListenerImpl(this.vertx.getOrCreateContext(), handler), batchPolicy, keys, binNames);
        return this;
    }

    @Override
    public AerospikeClient getHeader(BatchPolicy batchPolicy, Key[] keys, Handler<AsyncResult<List<Record>>> handler) throws AerospikeException {
        this.aerospikeClient.getHeader(this.eventLoops.next(), (RecordArrayListener)new RecordArrayListenerImpl(this.vertx.getOrCreateContext(), handler), batchPolicy, keys);
        return this;
    }

    @Override
    public AerospikeClient operate(WritePolicy writePolicy, Key key, Operation[] operations, Handler<AsyncResult<Record>> handler) throws AerospikeException {
        this.aerospikeClient.operate(this.eventLoops.next(), (RecordListener)new RecordListenerImpl(this.vertx.getOrCreateContext(), handler), writePolicy, key, operations);
        return this;
    }

    @Override
    public AerospikeClient scanAll(ScanPolicy policy, String namespace, String setName, String[] binNames, Handler<AsyncResult<List<KeyRecord>>> handler) throws AerospikeException {
        this.aerospikeClient.scanAll(this.eventLoops.next(), (RecordSequenceListener)new QueryResultListenerImpl(this.vertx.getOrCreateContext(), handler), policy, namespace, setName, binNames);
        return this;
    }

    @Override
    public AerospikeClient scanPartitions(ScanPolicy policy, PartitionFilter partitionFilter, String namespace, String setName, String[] binNames, Handler<AsyncResult<List<KeyRecord>>> handler) throws AerospikeException {
        this.aerospikeClient.scanPartitions(this.eventLoops.next(), (RecordSequenceListener)new QueryResultListenerImpl(this.vertx.getOrCreateContext(), handler), policy, partitionFilter, namespace, setName, binNames);
        return this;
    }

    @Override
    public AerospikeClient execute(WritePolicy writePolicy, Key key, String packageName, String functionName, Value[] functionArgs, Handler<AsyncResult<Object>> handler) throws AerospikeException {
        this.aerospikeClient.execute(this.eventLoops.next(), (ExecuteListener)new ExecuteListenerImpl(this.vertx.getOrCreateContext(), handler), writePolicy, key, packageName, functionName, functionArgs);
        return this;
    }

    @Override
    public AerospikeClient query(QueryPolicy queryPolicy, Statement statement, Handler<AsyncResult<List<KeyRecord>>> handler) throws AerospikeException {
        this.aerospikeClient.query(this.eventLoops.next(), (RecordSequenceListener)new QueryResultListenerImpl(this.vertx.getOrCreateContext(), handler), queryPolicy, statement);
        return this;
    }
}

