/*
 * Decompiled with CFR 0.152.
 */
package com.dream11.aerospike.config;

import com.aerospike.client.async.EventPolicy;
import com.aerospike.client.async.NettyEventLoops;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.Replica;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.vertx.codegen.annotations.Fluent;

public class AerospikeConnectOptions {
    static final String OS = System.getProperty("os.name");
    static final String DEFAULT_HOST = "localhost";
    static final int DEFAULT_PORT = 3000;
    static final int DEFAULT_EVENT_LOOP_SIZE = 2 * Runtime.getRuntime().availableProcessors();
    static final int DEFAULT_MAX_COMMANDS_IN_PROCESS = 100;
    static final int DEFAULT_MAX_CONNS_PER_NODE = 100 * DEFAULT_EVENT_LOOP_SIZE;
    static final int DEFAULT_MAX_CONNECT_RETRIES = 2;
    private String host;
    private int port;
    private int maxConnsPerNode;
    private int eventLoopSize;
    private int maxCommandsInProcess;
    private int maxCommandsInQueue;
    private ClientPolicy clientPolicy;
    private int maxConnectRetries;

    public AerospikeConnectOptions() {
        ClientPolicy clientPolicy = new ClientPolicy();
        clientPolicy.readPolicyDefault.replica = Replica.MASTER_PROLES;
        this.clientPolicy = clientPolicy;
        this.host = DEFAULT_HOST;
        this.port = 3000;
        this.maxConnsPerNode = DEFAULT_MAX_CONNS_PER_NODE;
        this.eventLoopSize = DEFAULT_EVENT_LOOP_SIZE;
        this.maxCommandsInProcess = 100;
        this.maxConnectRetries = 2;
    }

    @Fluent
    public AerospikeConnectOptions setMaxConnectRetries(int maxConnectRetries) {
        this.maxConnectRetries = maxConnectRetries;
        return this;
    }

    @Fluent
    public AerospikeConnectOptions setClientPolicy(ClientPolicy clientPolicy) {
        this.clientPolicy = clientPolicy;
        return this;
    }

    @Fluent
    public AerospikeConnectOptions setHost(String host) {
        this.host = host;
        return this;
    }

    @Fluent
    public AerospikeConnectOptions setPort(int port) {
        this.port = port;
        return this;
    }

    @Fluent
    public AerospikeConnectOptions setMaxConnsPerNode(int maxConnsPerNode) {
        this.maxConnsPerNode = maxConnsPerNode;
        return this;
    }

    @Fluent
    public AerospikeConnectOptions setEventLoopSize(int eventLoopSize) {
        this.eventLoopSize = eventLoopSize;
        return this;
    }

    @Fluent
    public AerospikeConnectOptions setMaxCommandsInProcess(int maxCommandsInProcess) {
        this.maxCommandsInProcess = maxCommandsInProcess;
        return this;
    }

    @Fluent
    public AerospikeConnectOptions setMaxCommandsInQueue(int maxCommandsInQueue) {
        this.maxCommandsInQueue = maxCommandsInQueue;
        return this;
    }

    @Fluent
    public AerospikeConnectOptions updateClientPolicy() {
        EventPolicy eventPolicy = new EventPolicy();
        eventPolicy.maxCommandsInProcess = this.getMaxCommandsInProcess();
        eventPolicy.maxCommandsInQueue = this.getMaxCommandsInQueue();
        EventLoopGroup group = this.getEventLoopGroup(this.getEventLoopSize());
        this.clientPolicy.eventLoops = new NettyEventLoops(eventPolicy, group);
        this.clientPolicy.maxConnsPerNode = this.getMaxConnsPerNode();
        return this;
    }

    private EventLoopGroup getEventLoopGroup(int size) {
        return OS.contains("linux") || OS.contains("unix") ? new EpollEventLoopGroup(size) : new NioEventLoopGroup(size);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getMaxConnsPerNode() {
        return this.maxConnsPerNode;
    }

    public int getEventLoopSize() {
        return this.eventLoopSize;
    }

    public int getMaxCommandsInProcess() {
        return this.maxCommandsInProcess;
    }

    public int getMaxCommandsInQueue() {
        return this.maxCommandsInQueue;
    }

    public ClientPolicy getClientPolicy() {
        return this.clientPolicy;
    }

    public int getMaxConnectRetries() {
        return this.maxConnectRetries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AerospikeConnectOptions)) {
            return false;
        }
        AerospikeConnectOptions other = (AerospikeConnectOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getMaxConnsPerNode() != other.getMaxConnsPerNode()) {
            return false;
        }
        if (this.getEventLoopSize() != other.getEventLoopSize()) {
            return false;
        }
        if (this.getMaxCommandsInProcess() != other.getMaxCommandsInProcess()) {
            return false;
        }
        if (this.getMaxCommandsInQueue() != other.getMaxCommandsInQueue()) {
            return false;
        }
        ClientPolicy this$clientPolicy = this.getClientPolicy();
        ClientPolicy other$clientPolicy = other.getClientPolicy();
        if (this$clientPolicy == null ? other$clientPolicy != null : !this$clientPolicy.equals(other$clientPolicy)) {
            return false;
        }
        return this.getMaxConnectRetries() == other.getMaxConnectRetries();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AerospikeConnectOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        result = result * 59 + this.getMaxConnsPerNode();
        result = result * 59 + this.getEventLoopSize();
        result = result * 59 + this.getMaxCommandsInProcess();
        result = result * 59 + this.getMaxCommandsInQueue();
        ClientPolicy $clientPolicy = this.getClientPolicy();
        result = result * 59 + ($clientPolicy == null ? 43 : $clientPolicy.hashCode());
        result = result * 59 + this.getMaxConnectRetries();
        return result;
    }

    public String toString() {
        return "AerospikeConnectOptions(host=" + this.getHost() + ", port=" + this.getPort() + ", maxConnsPerNode=" + this.getMaxConnsPerNode() + ", eventLoopSize=" + this.getEventLoopSize() + ", maxCommandsInProcess=" + this.getMaxCommandsInProcess() + ", maxCommandsInQueue=" + this.getMaxCommandsInQueue() + ", clientPolicy=" + this.getClientPolicy() + ", maxConnectRetries=" + this.getMaxConnectRetries() + ")";
    }
}

