/*
 * Decompiled with CFR 0.152.
 */
package io.cryptoapis.layers.omni_layer.services;

import io.cryptoapis.abstractServices.AbstractServicesConfig;
import io.cryptoapis.common_models.ApiResponse;
import io.cryptoapis.layers.omni_layer.models.CompleteTransaction;
import io.cryptoapis.layers.omni_layer.models.CreateHDWalletTransaction;
import io.cryptoapis.layers.omni_layer.models.CreateTransaction;
import io.cryptoapis.layers.omni_layer.models.SendTransaction;
import io.cryptoapis.layers.omni_layer.models.SignTransaction;
import io.cryptoapis.utils.config.EndpointConfig;
import io.cryptoapis.utils.enums.HttpsRequestsEnum;
import io.cryptoapis.utils.rest.WebServices;
import java.math.BigDecimal;

public class TransactionService
extends AbstractServicesConfig {
    private static final String PATH = "/{0}/bc/{1}/omni/{2}/txs{3}";
    private static final String QUERY_PARAMS = "/%s/%s?index=%d&limit=%d";
    private static final String EMPTY_STRING = "";

    protected TransactionService(EndpointConfig endpointConfig) {
        super(endpointConfig);
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    public ApiResponse createTransaction(String from, String to, BigDecimal value, BigDecimal fee, Integer propertyID) {
        CreateTransaction createTransaction = CreateTransaction.createTransaction(from, to, value, fee, propertyID);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "/create"), HttpsRequestsEnum.POST.name(), this.endpointConfig, createTransaction.toString());
    }

    public ApiResponse createTransaction(String from, String to, BigDecimal value, BigDecimal fee, Integer propertyID, String data, Integer locktime) {
        CreateTransaction createTransaction = CreateTransaction.createTransaction(from, to, value, fee, propertyID, data, locktime);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "/create"), HttpsRequestsEnum.POST.name(), this.endpointConfig, createTransaction.toString());
    }

    public ApiResponse signTransaction(String hex, String wif) {
        SignTransaction signTransaction = SignTransaction.signTransaction(hex, wif);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "/sign"), HttpsRequestsEnum.POST.name(), this.endpointConfig, signTransaction.toString());
    }

    public ApiResponse sendTransaction(String hex) {
        SendTransaction sendTransaction = SendTransaction.sendTransaction(hex);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "/send"), HttpsRequestsEnum.POST.name(), this.endpointConfig, sendTransaction.toString());
    }

    public ApiResponse createSignAndSendTransaction(String from, String to, BigDecimal value, BigDecimal fee, Integer propertyID, String wif) {
        CompleteTransaction completeTransaction = CompleteTransaction.createSignAndSend(from, to, value, fee, propertyID, wif);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "/new"), HttpsRequestsEnum.POST.name(), this.endpointConfig, completeTransaction.toString());
    }

    public ApiResponse createSignAndSendTransaction(String from, String to, BigDecimal value, BigDecimal fee, Integer propertyID, String wif, String data, Integer locktime) {
        CompleteTransaction completeTransaction = CompleteTransaction.createSignAndSend(from, to, value, fee, propertyID, wif, data, locktime);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "/new"), HttpsRequestsEnum.POST.name(), this.endpointConfig, completeTransaction.toString());
    }

    public ApiResponse createHDWalletTransaction(String walletName, String password, String from, String to, BigDecimal value, BigDecimal fee, Integer propertyID) {
        CreateHDWalletTransaction createHDWalletTransaction = CreateHDWalletTransaction.createHDWalletTransaction(walletName, password, from, to, value, fee, propertyID);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "/hdwallet"), HttpsRequestsEnum.POST.name(), this.endpointConfig, createHDWalletTransaction.toString());
    }

    public ApiResponse createHDWalletTransaction(String walletName, String password, String from, String to, BigDecimal value, BigDecimal fee, Integer propertyID, String data, Integer locktime) {
        CreateHDWalletTransaction createHDWalletTransaction = CreateHDWalletTransaction.createHDWalletTransaction(walletName, password, from, to, value, fee, propertyID, data, locktime);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "/hdwallet"), HttpsRequestsEnum.POST.name(), this.endpointConfig, createHDWalletTransaction.toString());
    }

    public ApiResponse getTransactionById(String txid) {
        String endpoint = String.format("/txid/%s", txid);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }

    public ApiResponse getTransactionsByBlockHeight(Integer block) {
        return this.createGetTransactionsByPropertyEndpoint(block, null, null, "block");
    }

    public ApiResponse getTransactionsByBlockHeight(Integer block, Integer index, Integer limit) {
        return this.createGetTransactionsByPropertyEndpoint(block, index, limit, "block");
    }

    public ApiResponse getTransactionsByPropertyId(Integer propertyId) {
        return this.createGetTransactionsByPropertyEndpoint(propertyId, null, null, "propertyid");
    }

    public ApiResponse getTransactionsByPropertyId(Integer propertyId, Integer index, Integer limit) {
        return this.createGetTransactionsByPropertyEndpoint(propertyId, index, limit, "propertyid");
    }

    public ApiResponse getUnconfirmedTransactions() {
        return this.createGetTransactionsByPropertyEndpoint(null, null, null, "unconfirmed");
    }

    public ApiResponse getUnconfirmedTransactions(Integer index, Integer limit) {
        return this.createGetTransactionsByPropertyEndpoint(null, index, limit, "unconfirmed");
    }

    private ApiResponse createGetTransactionsByPropertyEndpoint(Integer property, Integer index, Integer limit, String endpoint) {
        index = this.isValid(index) ? index : 0;
        limit = this.isValid(limit) ? limit : 50;
        String endpointProperty = property == null ? EMPTY_STRING : String.valueOf(property);
        endpoint = String.format(QUERY_PARAMS, endpoint, endpointProperty, index, limit);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }

    private boolean isValid(Integer param) {
        return param != null && param > 0;
    }
}

