/*
 * Decompiled with CFR 0.152.
 */
package io.cryptoapis.connections;

import io.cryptoapis.blockchains.zilliqa.services.AddressService;
import io.cryptoapis.blockchains.zilliqa.services.BlockService;
import io.cryptoapis.blockchains.zilliqa.services.BlockchainService;
import io.cryptoapis.blockchains.zilliqa.services.TransactionService;
import io.cryptoapis.connections.ConnectionConstructor;
import io.cryptoapis.utils.config.EndpointConfig;

public class Zilliqa
extends ConnectionConstructor {
    private TransactionService transactionService;
    private BlockchainService blockchainService;
    private BlockService blockService;
    private AddressService addressService;

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public BlockchainService getBlockchainService() {
        return this.blockchainService;
    }

    public BlockService getBlockService() {
        return this.blockService;
    }

    public AddressService getAddressService() {
        return this.addressService;
    }

    public Zilliqa(EndpointConfig endpointConfig) {
        this.initServices(endpointConfig);
    }

    protected void initServices(EndpointConfig endpointConfig) {
        try {
            this.addressService = this.getConstructor(AddressService.class).newInstance(endpointConfig);
            this.blockchainService = this.getConstructor(BlockchainService.class).newInstance(endpointConfig);
            this.blockService = this.getConstructor(BlockService.class).newInstance(endpointConfig);
            this.transactionService = this.getConstructor(TransactionService.class).newInstance(endpointConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

