/*
 * Decompiled with CFR 0.152.
 */
package io.cryptoapis.blockchains.zilliqa.services;

import io.cryptoapis.abstractServices.AbstractServicesConfig;
import io.cryptoapis.common_models.ApiResponse;
import io.cryptoapis.utils.config.EndpointConfig;
import io.cryptoapis.utils.enums.HttpsRequestsEnum;
import io.cryptoapis.utils.rest.WebServices;

public class BlockService
extends AbstractServicesConfig {
    private static final String PATH = "/{0}/bc/{1}/{2}/blocks/{3}";

    protected BlockService(EndpointConfig endpointConfig) {
        super(endpointConfig);
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    public ApiResponse getBlock(String blockHash) {
        return this.fetchBlock(blockHash);
    }

    public ApiResponse getBlock(int blockNumber) {
        return this.fetchBlock(String.format("%s", blockNumber));
    }

    public ApiResponse getLatestBlock() {
        return this.fetchBlock("latest");
    }

    private ApiResponse fetchBlock(String endpoint) {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }
}

