/*
 * Decompiled with CFR 0.152.
 */
package io.cryptoapis.exchanges.services;

import io.cryptoapis.abstractServices.AbstractServicesConfig;
import io.cryptoapis.common_models.ApiResponse;
import io.cryptoapis.utils.Utils;
import io.cryptoapis.utils.config.EndpointConfig;
import java.util.Map;

public class TradesService
extends AbstractServicesConfig {
    private static final String PATH = "/{0}/trades/{1}";

    public TradesService(EndpointConfig endpointConfig) {
        super(endpointConfig);
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    public ApiResponse getLatestData(Map<String, String> params) {
        return Utils.sendListRequest("latest", params, this.url, this.endpointConfig);
    }

    public ApiResponse getHistoricalData(String symbol, Map<String, String> params) {
        String endpoint = String.format("%s/history?", symbol);
        return Utils.sendListRequest(endpoint, params, this.url, this.endpointConfig);
    }

    public ApiResponse getLatestDataBySymbol(String symbol, Map<String, String> params) {
        String endpoint = String.format("%s/%s", symbol, "latest");
        return Utils.sendListRequest(endpoint, params, this.url, this.endpointConfig);
    }
}

