/*
 * Decompiled with CFR 0.152.
 */
package io.cryptoapis.connections;

import io.cryptoapis.connections.ConnectionConstructor;
import io.cryptoapis.exchanges.services.ExchangeRatesService;
import io.cryptoapis.exchanges.services.MetadataService;
import io.cryptoapis.exchanges.services.OHLCVService;
import io.cryptoapis.exchanges.services.OrderBookService;
import io.cryptoapis.exchanges.services.TradesService;
import io.cryptoapis.utils.config.EndpointConfig;

public class Exchanges
extends ConnectionConstructor {
    private MetadataService metadataService;
    private ExchangeRatesService exchangeRatesService;
    private OHLCVService ohlcvService;
    private TradesService tradesService;
    private OrderBookService orderBookService;

    public Exchanges(EndpointConfig endpointConfig) {
        this.initServices(endpointConfig);
    }

    public MetadataService getMetadataService() {
        return this.metadataService;
    }

    public ExchangeRatesService getExchangeRatesService() {
        return this.exchangeRatesService;
    }

    public OHLCVService getOhlcvService() {
        return this.ohlcvService;
    }

    public TradesService getTradesService() {
        return this.tradesService;
    }

    public OrderBookService getOrderBookService() {
        return this.orderBookService;
    }

    private void initServices(EndpointConfig endpointConfig) {
        try {
            this.metadataService = this.getConstructor(MetadataService.class).newInstance(endpointConfig);
            this.exchangeRatesService = this.getConstructor(ExchangeRatesService.class).newInstance(endpointConfig);
            this.ohlcvService = this.getConstructor(OHLCVService.class).newInstance(endpointConfig);
            this.tradesService = this.getConstructor(TradesService.class).newInstance(endpointConfig);
            this.orderBookService = this.getConstructor(OrderBookService.class).newInstance(endpointConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

